// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.Analysis.Models
{
    /// <summary> An array of firewall rules. </summary>
    public partial class AnalysisIPv4FirewallSettings
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="AnalysisIPv4FirewallSettings"/>. </summary>
        public AnalysisIPv4FirewallSettings()
        {
            FirewallRules = new ChangeTrackingList<AnalysisIPv4FirewallRule>();
        }

        /// <summary> Initializes a new instance of <see cref="AnalysisIPv4FirewallSettings"/>. </summary>
        /// <param name="firewallRules"> An array of firewall rules. </param>
        /// <param name="isPowerBIServiceEnabled"> The indicator of enabling PBI service. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal AnalysisIPv4FirewallSettings(IList<AnalysisIPv4FirewallRule> firewallRules, bool? isPowerBIServiceEnabled, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            FirewallRules = firewallRules;
            IsPowerBIServiceEnabled = isPowerBIServiceEnabled;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> An array of firewall rules. </summary>
        public IList<AnalysisIPv4FirewallRule> FirewallRules { get; }
        /// <summary> The indicator of enabling PBI service. </summary>
        public bool? IsPowerBIServiceEnabled { get; set; }
    }
}
