// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.Analysis.Models
{
    /// <summary> The detail of firewall rule. </summary>
    public partial class AnalysisIPv4FirewallRule
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="AnalysisIPv4FirewallRule"/>. </summary>
        public AnalysisIPv4FirewallRule()
        {
        }

        /// <summary> Initializes a new instance of <see cref="AnalysisIPv4FirewallRule"/>. </summary>
        /// <param name="firewallRuleName"> The rule name. </param>
        /// <param name="rangeStart"> The start range of IPv4. </param>
        /// <param name="rangeEnd"> The end range of IPv4. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal AnalysisIPv4FirewallRule(string firewallRuleName, string rangeStart, string rangeEnd, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            FirewallRuleName = firewallRuleName;
            RangeStart = rangeStart;
            RangeEnd = rangeEnd;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> The rule name. </summary>
        public string FirewallRuleName { get; set; }
        /// <summary> The start range of IPv4. </summary>
        public string RangeStart { get; set; }
        /// <summary> The end range of IPv4. </summary>
        public string RangeEnd { get; set; }
    }
}
