// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ClientModel.Primitives;
using System.Collections.Generic;
using System.Text.Json;
using Azure.Core;

namespace Azure.ResourceManager.Analysis.Models
{
    public partial class AnalysisGatewayDetails : IUtf8JsonSerializable, IJsonModel<AnalysisGatewayDetails>
    {
        void IUtf8JsonSerializable.Write(Utf8JsonWriter writer) => ((IJsonModel<AnalysisGatewayDetails>)this).Write(writer, ModelSerializationExtensions.WireOptions);

        void IJsonModel<AnalysisGatewayDetails>.Write(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            writer.WriteStartObject();
            JsonModelWriteCore(writer, options);
            writer.WriteEndObject();
        }

        /// <param name="writer"> The JSON writer. </param>
        /// <param name="options"> The client options for reading and writing models. </param>
        protected virtual void JsonModelWriteCore(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<AnalysisGatewayDetails>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(AnalysisGatewayDetails)} does not support writing '{format}' format.");
            }

            if (Optional.IsDefined(GatewayResourceId))
            {
                writer.WritePropertyName("gatewayResourceId"u8);
                writer.WriteStringValue(GatewayResourceId);
            }
            if (options.Format != "W" && Optional.IsDefined(GatewayObjectId))
            {
                writer.WritePropertyName("gatewayObjectId"u8);
                writer.WriteStringValue(GatewayObjectId);
            }
            if (options.Format != "W" && Optional.IsDefined(DmtsClusterUri))
            {
                writer.WritePropertyName("dmtsClusterUri"u8);
                writer.WriteStringValue(DmtsClusterUri.AbsoluteUri);
            }
            if (options.Format != "W" && _serializedAdditionalRawData != null)
            {
                foreach (var item in _serializedAdditionalRawData)
                {
                    writer.WritePropertyName(item.Key);
#if NET6_0_OR_GREATER
				writer.WriteRawValue(item.Value);
#else
                    using (JsonDocument document = JsonDocument.Parse(item.Value))
                    {
                        JsonSerializer.Serialize(writer, document.RootElement);
                    }
#endif
                }
            }
        }

        AnalysisGatewayDetails IJsonModel<AnalysisGatewayDetails>.Create(ref Utf8JsonReader reader, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<AnalysisGatewayDetails>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(AnalysisGatewayDetails)} does not support reading '{format}' format.");
            }

            using JsonDocument document = JsonDocument.ParseValue(ref reader);
            return DeserializeAnalysisGatewayDetails(document.RootElement, options);
        }

        internal static AnalysisGatewayDetails DeserializeAnalysisGatewayDetails(JsonElement element, ModelReaderWriterOptions options = null)
        {
            options ??= ModelSerializationExtensions.WireOptions;

            if (element.ValueKind == JsonValueKind.Null)
            {
                return null;
            }
            string gatewayResourceId = default;
            string gatewayObjectId = default;
            Uri dmtsClusterUri = default;
            IDictionary<string, BinaryData> serializedAdditionalRawData = default;
            Dictionary<string, BinaryData> rawDataDictionary = new Dictionary<string, BinaryData>();
            foreach (var property in element.EnumerateObject())
            {
                if (property.NameEquals("gatewayResourceId"u8))
                {
                    gatewayResourceId = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("gatewayObjectId"u8))
                {
                    gatewayObjectId = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("dmtsClusterUri"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    dmtsClusterUri = new Uri(property.Value.GetString());
                    continue;
                }
                if (options.Format != "W")
                {
                    rawDataDictionary.Add(property.Name, BinaryData.FromString(property.Value.GetRawText()));
                }
            }
            serializedAdditionalRawData = rawDataDictionary;
            return new AnalysisGatewayDetails(gatewayResourceId, gatewayObjectId, dmtsClusterUri, serializedAdditionalRawData);
        }

        BinaryData IPersistableModel<AnalysisGatewayDetails>.Write(ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<AnalysisGatewayDetails>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    return ModelReaderWriter.Write(this, options);
                default:
                    throw new FormatException($"The model {nameof(AnalysisGatewayDetails)} does not support writing '{options.Format}' format.");
            }
        }

        AnalysisGatewayDetails IPersistableModel<AnalysisGatewayDetails>.Create(BinaryData data, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<AnalysisGatewayDetails>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    {
                        using JsonDocument document = JsonDocument.Parse(data);
                        return DeserializeAnalysisGatewayDetails(document.RootElement, options);
                    }
                default:
                    throw new FormatException($"The model {nameof(AnalysisGatewayDetails)} does not support reading '{options.Format}' format.");
            }
        }

        string IPersistableModel<AnalysisGatewayDetails>.GetFormatFromOptions(ModelReaderWriterOptions options) => "J";
    }
}
