// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System.Text.Json;
using System.Threading;
using System.Threading.Tasks;
using Azure.Core;

namespace Azure.ResourceManager.Analysis
{
    internal class AnalysisServerOperationSource : IOperationSource<AnalysisServerResource>
    {
        private readonly ArmClient _client;

        internal AnalysisServerOperationSource(ArmClient client)
        {
            _client = client;
        }

        AnalysisServerResource IOperationSource<AnalysisServerResource>.CreateResult(Response response, CancellationToken cancellationToken)
        {
            using var document = JsonDocument.Parse(response.ContentStream);
            var data = AnalysisServerData.DeserializeAnalysisServerData(document.RootElement);
            return new AnalysisServerResource(_client, data);
        }

        async ValueTask<AnalysisServerResource> IOperationSource<AnalysisServerResource>.CreateResultAsync(Response response, CancellationToken cancellationToken)
        {
            using var document = await JsonDocument.ParseAsync(response.ContentStream, default, cancellationToken).ConfigureAwait(false);
            var data = AnalysisServerData.DeserializeAnalysisServerData(document.RootElement);
            return new AnalysisServerResource(_client, data);
        }
    }
}
