// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;
using System.Linq;
using Azure.Core;
using Azure.ResourceManager.Models;

namespace Azure.ResourceManager.Analysis.Models
{
    /// <summary> Model factory for models. </summary>
    public static partial class ArmAnalysisModelFactory
    {
        /// <summary> Initializes a new instance of <see cref="Analysis.AnalysisServerData"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="tags"> The tags. </param>
        /// <param name="location"> The location. </param>
        /// <param name="asAdministratorIdentities"> A collection of AS server administrators. </param>
        /// <param name="backupBlobContainerUri"> The SAS container URI to the backup container. </param>
        /// <param name="gatewayDetails"> The gateway details configured for the AS server. </param>
        /// <param name="iPv4FirewallSettings"> The firewall settings for the AS server. </param>
        /// <param name="queryPoolConnectionMode"> How the read-write server's participation in the query pool is controlled.&lt;br/&gt;It can have the following values: &lt;ul&gt;&lt;li&gt;readOnly - indicates that the read-write server is intended not to participate in query operations&lt;/li&gt;&lt;li&gt;all - indicates that the read-write server can participate in query operations&lt;/li&gt;&lt;/ul&gt;Specifying readOnly when capacity is 1 results in error. </param>
        /// <param name="managedMode"> The managed mode of the server (0 = not managed, 1 = managed). </param>
        /// <param name="serverMonitorMode"> The server monitor mode for AS server. </param>
        /// <param name="state"> The current state of Analysis Services resource. The state is to indicate more states outside of resource provisioning. </param>
        /// <param name="provisioningState"> The current deployment state of Analysis Services resource. The provisioningState is to indicate states for resource provisioning. </param>
        /// <param name="serverFullName"> The full name of the Analysis Services resource. </param>
        /// <param name="analysisServerSku"> The SKU of the Analysis Services resource. </param>
        /// <param name="analysisSku"> The SKU of the Analysis Services resource. </param>
        /// <returns> A new <see cref="Analysis.AnalysisServerData"/> instance for mocking. </returns>
        public static AnalysisServerData AnalysisServerData(ResourceIdentifier id = null, string name = null, ResourceType resourceType = default, SystemData systemData = null, IDictionary<string, string> tags = null, AzureLocation location = default, IEnumerable<string> asAdministratorIdentities = null, Uri backupBlobContainerUri = null, AnalysisGatewayDetails gatewayDetails = null, AnalysisIPv4FirewallSettings iPv4FirewallSettings = null, AnalysisConnectionMode? queryPoolConnectionMode = null, AnalysisManagedMode? managedMode = null, ServerMonitorMode? serverMonitorMode = null, AnalysisState? state = null, AnalysisProvisioningState? provisioningState = null, string serverFullName = null, AnalysisResourceSku analysisServerSku = null, AnalysisResourceSku analysisSku = null)
        {
            tags ??= new Dictionary<string, string>();
            asAdministratorIdentities ??= new List<string>();

            return new AnalysisServerData(
                id,
                name,
                resourceType,
                systemData,
                tags,
                location,
                asAdministratorIdentities != null ? new ServerAdministrators(asAdministratorIdentities?.ToList(), serializedAdditionalRawData: null) : null,
                backupBlobContainerUri,
                gatewayDetails,
                iPv4FirewallSettings,
                queryPoolConnectionMode,
                managedMode,
                serverMonitorMode,
                state,
                provisioningState,
                serverFullName,
                analysisServerSku,
                analysisSku,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.AnalysisGatewayDetails"/>. </summary>
        /// <param name="gatewayResourceId"> Gateway resource to be associated with the server. </param>
        /// <param name="gatewayObjectId"> Gateway object id from in the DMTS cluster for the gateway resource. </param>
        /// <param name="dmtsClusterUri"> Uri of the DMTS cluster. </param>
        /// <returns> A new <see cref="Models.AnalysisGatewayDetails"/> instance for mocking. </returns>
        public static AnalysisGatewayDetails AnalysisGatewayDetails(string gatewayResourceId = null, string gatewayObjectId = null, Uri dmtsClusterUri = null)
        {
            return new AnalysisGatewayDetails(gatewayResourceId, gatewayObjectId, dmtsClusterUri, serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.AnalysisExistingSku"/>. </summary>
        /// <param name="sku"> The SKU in SKU details for existing resources. </param>
        /// <param name="resourceType"> The resource type. </param>
        /// <returns> A new <see cref="Models.AnalysisExistingSku"/> instance for mocking. </returns>
        public static AnalysisExistingSku AnalysisExistingSku(AnalysisResourceSku sku = null, ResourceType? resourceType = null)
        {
            return new AnalysisExistingSku(sku, resourceType, serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.AnalysisGatewayStatus"/>. </summary>
        /// <param name="status"> Live message of list gateway. Status: 0 - Live. </param>
        /// <returns> A new <see cref="Models.AnalysisGatewayStatus"/> instance for mocking. </returns>
        public static AnalysisGatewayStatus AnalysisGatewayStatus(AnalysisStatus? status = null)
        {
            return new AnalysisGatewayStatus(status, serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.AnalysisServerNameAvailabilityResult"/>. </summary>
        /// <param name="isNameAvailable"> Indicator of available of the server name. </param>
        /// <param name="reason"> The reason of unavailability. </param>
        /// <param name="message"> The detailed message of the request unavailability. </param>
        /// <returns> A new <see cref="Models.AnalysisServerNameAvailabilityResult"/> instance for mocking. </returns>
        public static AnalysisServerNameAvailabilityResult AnalysisServerNameAvailabilityResult(bool? isNameAvailable = null, string reason = null, string message = null)
        {
            return new AnalysisServerNameAvailabilityResult(isNameAvailable, reason, message, serializedAdditionalRawData: null);
        }
    }
}
