// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ClientModel.Primitives;
using System.Collections.Generic;
using System.Text.Json;
using Azure.Core;
using Azure.ResourceManager.Analysis.Models;
using Azure.ResourceManager.Models;

namespace Azure.ResourceManager.Analysis
{
    public partial class AnalysisServerData : IUtf8JsonSerializable, IJsonModel<AnalysisServerData>
    {
        void IUtf8JsonSerializable.Write(Utf8JsonWriter writer) => ((IJsonModel<AnalysisServerData>)this).Write(writer, ModelSerializationExtensions.WireOptions);

        void IJsonModel<AnalysisServerData>.Write(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            writer.WriteStartObject();
            JsonModelWriteCore(writer, options);
            writer.WriteEndObject();
        }

        /// <param name="writer"> The JSON writer. </param>
        /// <param name="options"> The client options for reading and writing models. </param>
        protected override void JsonModelWriteCore(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<AnalysisServerData>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(AnalysisServerData)} does not support writing '{format}' format.");
            }

            base.JsonModelWriteCore(writer, options);
            writer.WritePropertyName("sku"u8);
            writer.WriteObjectValue(AnalysisSku, options);
            writer.WritePropertyName("properties"u8);
            writer.WriteStartObject();
            if (Optional.IsDefined(AsAdministrators))
            {
                writer.WritePropertyName("asAdministrators"u8);
                writer.WriteObjectValue(AsAdministrators, options);
            }
            if (Optional.IsDefined(BackupBlobContainerUri))
            {
                writer.WritePropertyName("backupBlobContainerUri"u8);
                writer.WriteStringValue(BackupBlobContainerUri.AbsoluteUri);
            }
            if (Optional.IsDefined(GatewayDetails))
            {
                writer.WritePropertyName("gatewayDetails"u8);
                writer.WriteObjectValue(GatewayDetails, options);
            }
            if (Optional.IsDefined(IPv4FirewallSettings))
            {
                writer.WritePropertyName("ipV4FirewallSettings"u8);
                writer.WriteObjectValue(IPv4FirewallSettings, options);
            }
            if (Optional.IsDefined(QueryPoolConnectionMode))
            {
                writer.WritePropertyName("querypoolConnectionMode"u8);
                writer.WriteStringValue(QueryPoolConnectionMode.Value.ToSerialString());
            }
            if (Optional.IsDefined(ManagedMode))
            {
                writer.WritePropertyName("managedMode"u8);
                writer.WriteNumberValue(ManagedMode.Value.ToSerialInt32());
            }
            if (Optional.IsDefined(ServerMonitorMode))
            {
                writer.WritePropertyName("serverMonitorMode"u8);
                writer.WriteNumberValue(ServerMonitorMode.Value.ToSerialInt32());
            }
            if (options.Format != "W" && Optional.IsDefined(State))
            {
                writer.WritePropertyName("state"u8);
                writer.WriteStringValue(State.Value.ToString());
            }
            if (options.Format != "W" && Optional.IsDefined(ProvisioningState))
            {
                writer.WritePropertyName("provisioningState"u8);
                writer.WriteStringValue(ProvisioningState.Value.ToString());
            }
            if (options.Format != "W" && Optional.IsDefined(ServerFullName))
            {
                writer.WritePropertyName("serverFullName"u8);
                writer.WriteStringValue(ServerFullName);
            }
            if (Optional.IsDefined(AnalysisServerSku))
            {
                writer.WritePropertyName("sku"u8);
                writer.WriteObjectValue(AnalysisServerSku, options);
            }
            writer.WriteEndObject();
        }

        AnalysisServerData IJsonModel<AnalysisServerData>.Create(ref Utf8JsonReader reader, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<AnalysisServerData>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(AnalysisServerData)} does not support reading '{format}' format.");
            }

            using JsonDocument document = JsonDocument.ParseValue(ref reader);
            return DeserializeAnalysisServerData(document.RootElement, options);
        }

        internal static AnalysisServerData DeserializeAnalysisServerData(JsonElement element, ModelReaderWriterOptions options = null)
        {
            options ??= ModelSerializationExtensions.WireOptions;

            if (element.ValueKind == JsonValueKind.Null)
            {
                return null;
            }
            AnalysisResourceSku sku = default;
            IDictionary<string, string> tags = default;
            AzureLocation location = default;
            ResourceIdentifier id = default;
            string name = default;
            ResourceType type = default;
            SystemData systemData = default;
            ServerAdministrators asAdministrators = default;
            Uri backupBlobContainerUri = default;
            AnalysisGatewayDetails gatewayDetails = default;
            AnalysisIPv4FirewallSettings ipV4FirewallSettings = default;
            AnalysisConnectionMode? querypoolConnectionMode = default;
            AnalysisManagedMode? managedMode = default;
            ServerMonitorMode? serverMonitorMode = default;
            AnalysisState? state = default;
            AnalysisProvisioningState? provisioningState = default;
            string serverFullName = default;
            AnalysisResourceSku sku0 = default;
            IDictionary<string, BinaryData> serializedAdditionalRawData = default;
            Dictionary<string, BinaryData> rawDataDictionary = new Dictionary<string, BinaryData>();
            foreach (var property in element.EnumerateObject())
            {
                if (property.NameEquals("sku"u8))
                {
                    sku = AnalysisResourceSku.DeserializeAnalysisResourceSku(property.Value, options);
                    continue;
                }
                if (property.NameEquals("tags"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    Dictionary<string, string> dictionary = new Dictionary<string, string>();
                    foreach (var property0 in property.Value.EnumerateObject())
                    {
                        dictionary.Add(property0.Name, property0.Value.GetString());
                    }
                    tags = dictionary;
                    continue;
                }
                if (property.NameEquals("location"u8))
                {
                    location = new AzureLocation(property.Value.GetString());
                    continue;
                }
                if (property.NameEquals("id"u8))
                {
                    id = new ResourceIdentifier(property.Value.GetString());
                    continue;
                }
                if (property.NameEquals("name"u8))
                {
                    name = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("type"u8))
                {
                    type = new ResourceType(property.Value.GetString());
                    continue;
                }
                if (property.NameEquals("systemData"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    systemData = JsonSerializer.Deserialize<SystemData>(property.Value.GetRawText());
                    continue;
                }
                if (property.NameEquals("properties"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        property.ThrowNonNullablePropertyIsNull();
                        continue;
                    }
                    foreach (var property0 in property.Value.EnumerateObject())
                    {
                        if (property0.NameEquals("asAdministrators"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            asAdministrators = ServerAdministrators.DeserializeServerAdministrators(property0.Value, options);
                            continue;
                        }
                        if (property0.NameEquals("backupBlobContainerUri"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            backupBlobContainerUri = new Uri(property0.Value.GetString());
                            continue;
                        }
                        if (property0.NameEquals("gatewayDetails"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            gatewayDetails = AnalysisGatewayDetails.DeserializeAnalysisGatewayDetails(property0.Value, options);
                            continue;
                        }
                        if (property0.NameEquals("ipV4FirewallSettings"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            ipV4FirewallSettings = AnalysisIPv4FirewallSettings.DeserializeAnalysisIPv4FirewallSettings(property0.Value, options);
                            continue;
                        }
                        if (property0.NameEquals("querypoolConnectionMode"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            querypoolConnectionMode = property0.Value.GetString().ToAnalysisConnectionMode();
                            continue;
                        }
                        if (property0.NameEquals("managedMode"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            managedMode = new AnalysisManagedMode(property0.Value.GetInt32());
                            continue;
                        }
                        if (property0.NameEquals("serverMonitorMode"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            serverMonitorMode = new ServerMonitorMode(property0.Value.GetInt32());
                            continue;
                        }
                        if (property0.NameEquals("state"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            state = new AnalysisState(property0.Value.GetString());
                            continue;
                        }
                        if (property0.NameEquals("provisioningState"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            provisioningState = new AnalysisProvisioningState(property0.Value.GetString());
                            continue;
                        }
                        if (property0.NameEquals("serverFullName"u8))
                        {
                            serverFullName = property0.Value.GetString();
                            continue;
                        }
                        if (property0.NameEquals("sku"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            sku0 = AnalysisResourceSku.DeserializeAnalysisResourceSku(property0.Value, options);
                            continue;
                        }
                    }
                    continue;
                }
                if (options.Format != "W")
                {
                    rawDataDictionary.Add(property.Name, BinaryData.FromString(property.Value.GetRawText()));
                }
            }
            serializedAdditionalRawData = rawDataDictionary;
            return new AnalysisServerData(
                id,
                name,
                type,
                systemData,
                tags ?? new ChangeTrackingDictionary<string, string>(),
                location,
                asAdministrators,
                backupBlobContainerUri,
                gatewayDetails,
                ipV4FirewallSettings,
                querypoolConnectionMode,
                managedMode,
                serverMonitorMode,
                state,
                provisioningState,
                serverFullName,
                sku0,
                sku,
                serializedAdditionalRawData);
        }

        BinaryData IPersistableModel<AnalysisServerData>.Write(ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<AnalysisServerData>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    return ModelReaderWriter.Write(this, options);
                default:
                    throw new FormatException($"The model {nameof(AnalysisServerData)} does not support writing '{options.Format}' format.");
            }
        }

        AnalysisServerData IPersistableModel<AnalysisServerData>.Create(BinaryData data, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<AnalysisServerData>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    {
                        using JsonDocument document = JsonDocument.Parse(data);
                        return DeserializeAnalysisServerData(document.RootElement, options);
                    }
                default:
                    throw new FormatException($"The model {nameof(AnalysisServerData)} does not support reading '{options.Format}' format.");
            }
        }

        string IPersistableModel<AnalysisServerData>.GetFormatFromOptions(ModelReaderWriterOptions options) => "J";
    }
}
