// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Globalization;
using System.Threading;
using System.Threading.Tasks;
using Azure.Core;
using Azure.Core.Pipeline;
using Azure.ResourceManager.AlertsManagement.Models;
using Azure.ResourceManager.Resources;

namespace Azure.ResourceManager.AlertsManagement
{
    /// <summary>
    /// A Class representing a SmartGroup along with the instance operations that can be performed on it.
    /// If you have a <see cref="ResourceIdentifier"/> you can construct a <see cref="SmartGroupResource"/>
    /// from an instance of <see cref="ArmClient"/> using the GetSmartGroupResource method.
    /// Otherwise you can get one from its parent resource <see cref="SubscriptionResource"/> using the GetSmartGroup method.
    /// </summary>
    public partial class SmartGroupResource : ArmResource
    {
        /// <summary> Generate the resource identifier of a <see cref="SmartGroupResource"/> instance. </summary>
        /// <param name="subscriptionId"> The subscriptionId. </param>
        /// <param name="smartGroupId"> The smartGroupId. </param>
        public static ResourceIdentifier CreateResourceIdentifier(string subscriptionId, Guid smartGroupId)
        {
            var resourceId = $"/subscriptions/{subscriptionId}/providers/Microsoft.AlertsManagement/smartGroups/{smartGroupId}";
            return new ResourceIdentifier(resourceId);
        }

        private readonly ClientDiagnostics _smartGroupClientDiagnostics;
        private readonly SmartGroupsRestOperations _smartGroupRestClient;
        private readonly SmartGroupData _data;

        /// <summary> Gets the resource type for the operations. </summary>
        public static readonly ResourceType ResourceType = "Microsoft.AlertsManagement/smartGroups";

        /// <summary> Initializes a new instance of the <see cref="SmartGroupResource"/> class for mocking. </summary>
        protected SmartGroupResource()
        {
        }

        /// <summary> Initializes a new instance of the <see cref="SmartGroupResource"/> class. </summary>
        /// <param name="client"> The client parameters to use in these operations. </param>
        /// <param name="data"> The resource that is the target of operations. </param>
        internal SmartGroupResource(ArmClient client, SmartGroupData data) : this(client, data.Id)
        {
            HasData = true;
            _data = data;
        }

        /// <summary> Initializes a new instance of the <see cref="SmartGroupResource"/> class. </summary>
        /// <param name="client"> The client parameters to use in these operations. </param>
        /// <param name="id"> The identifier of the resource that is the target of operations. </param>
        internal SmartGroupResource(ArmClient client, ResourceIdentifier id) : base(client, id)
        {
            _smartGroupClientDiagnostics = new ClientDiagnostics("Azure.ResourceManager.AlertsManagement", ResourceType.Namespace, Diagnostics);
            TryGetApiVersion(ResourceType, out string smartGroupApiVersion);
            _smartGroupRestClient = new SmartGroupsRestOperations(Pipeline, Diagnostics.ApplicationId, Endpoint, smartGroupApiVersion);
#if DEBUG
			ValidateResourceId(Id);
#endif
        }

        /// <summary> Gets whether or not the current instance has data. </summary>
        public virtual bool HasData { get; }

        /// <summary> Gets the data representing this Feature. </summary>
        /// <exception cref="InvalidOperationException"> Throws if there is no data loaded in the current instance. </exception>
        public virtual SmartGroupData Data
        {
            get
            {
                if (!HasData)
                    throw new InvalidOperationException("The current instance does not have data, you must call Get first.");
                return _data;
            }
        }

        internal static void ValidateResourceId(ResourceIdentifier id)
        {
            if (id.ResourceType != ResourceType)
                throw new ArgumentException(string.Format(CultureInfo.CurrentCulture, "Invalid resource type {0} expected {1}", id.ResourceType, ResourceType), nameof(id));
        }

        /// <summary>
        /// Get information related to a specific Smart Group.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/providers/Microsoft.AlertsManagement/smartGroups/{smartGroupId}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>SmartGroups_GetById</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2019-05-05-preview</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="SmartGroupResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        public virtual async Task<Response<SmartGroupResource>> GetAsync(CancellationToken cancellationToken = default)
        {
            using var scope = _smartGroupClientDiagnostics.CreateScope("SmartGroupResource.Get");
            scope.Start();
            try
            {
                var response = await _smartGroupRestClient.GetByIdAsync(Id.SubscriptionId, Guid.Parse(Id.Name), cancellationToken).ConfigureAwait(false);
                if (response.Value == null)
                    throw new RequestFailedException(response.GetRawResponse());
                return Response.FromValue(new SmartGroupResource(Client, response.Value), response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Get information related to a specific Smart Group.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/providers/Microsoft.AlertsManagement/smartGroups/{smartGroupId}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>SmartGroups_GetById</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2019-05-05-preview</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="SmartGroupResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        public virtual Response<SmartGroupResource> Get(CancellationToken cancellationToken = default)
        {
            using var scope = _smartGroupClientDiagnostics.CreateScope("SmartGroupResource.Get");
            scope.Start();
            try
            {
                var response = _smartGroupRestClient.GetById(Id.SubscriptionId, Guid.Parse(Id.Name), cancellationToken);
                if (response.Value == null)
                    throw new RequestFailedException(response.GetRawResponse());
                return Response.FromValue(new SmartGroupResource(Client, response.Value), response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Change the state of a Smart Group.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/providers/Microsoft.AlertsManagement/smartGroups/{smartGroupId}/changeState</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>SmartGroups_ChangeState</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2019-05-05-preview</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="SmartGroupResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="newState"> New state of the alert. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        public virtual async Task<Response<SmartGroupResource>> ChangeStateAsync(ServiceAlertState newState, CancellationToken cancellationToken = default)
        {
            using var scope = _smartGroupClientDiagnostics.CreateScope("SmartGroupResource.ChangeState");
            scope.Start();
            try
            {
                var response = await _smartGroupRestClient.ChangeStateAsync(Id.SubscriptionId, Guid.Parse(Id.Name), newState, cancellationToken).ConfigureAwait(false);
                return Response.FromValue(new SmartGroupResource(Client, response.Value), response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Change the state of a Smart Group.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/providers/Microsoft.AlertsManagement/smartGroups/{smartGroupId}/changeState</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>SmartGroups_ChangeState</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2019-05-05-preview</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="SmartGroupResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="newState"> New state of the alert. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        public virtual Response<SmartGroupResource> ChangeState(ServiceAlertState newState, CancellationToken cancellationToken = default)
        {
            using var scope = _smartGroupClientDiagnostics.CreateScope("SmartGroupResource.ChangeState");
            scope.Start();
            try
            {
                var response = _smartGroupRestClient.ChangeState(Id.SubscriptionId, Guid.Parse(Id.Name), newState, cancellationToken);
                return Response.FromValue(new SmartGroupResource(Client, response.Value), response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Get the history a smart group, which captures any Smart Group state changes (New/Acknowledged/Closed) .
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/providers/Microsoft.AlertsManagement/smartGroups/{smartGroupId}/history</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>SmartGroups_GetHistory</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2019-05-05-preview</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="SmartGroupResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        public virtual async Task<Response<SmartGroupModification>> GetHistoryAsync(CancellationToken cancellationToken = default)
        {
            using var scope = _smartGroupClientDiagnostics.CreateScope("SmartGroupResource.GetHistory");
            scope.Start();
            try
            {
                var response = await _smartGroupRestClient.GetHistoryAsync(Id.SubscriptionId, Guid.Parse(Id.Name), cancellationToken).ConfigureAwait(false);
                return response;
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Get the history a smart group, which captures any Smart Group state changes (New/Acknowledged/Closed) .
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/providers/Microsoft.AlertsManagement/smartGroups/{smartGroupId}/history</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>SmartGroups_GetHistory</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2019-05-05-preview</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="SmartGroupResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        public virtual Response<SmartGroupModification> GetHistory(CancellationToken cancellationToken = default)
        {
            using var scope = _smartGroupClientDiagnostics.CreateScope("SmartGroupResource.GetHistory");
            scope.Start();
            try
            {
                var response = _smartGroupRestClient.GetHistory(Id.SubscriptionId, Guid.Parse(Id.Name), cancellationToken);
                return response;
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }
    }
}
