// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ClientModel.Primitives;
using System.Collections.Generic;
using System.Text.Json;
using Azure.Core;
using Azure.ResourceManager.AlertsManagement.Models;
using Azure.ResourceManager.Models;

namespace Azure.ResourceManager.AlertsManagement
{
    public partial class SmartGroupData : IUtf8JsonSerializable, IJsonModel<SmartGroupData>
    {
        void IUtf8JsonSerializable.Write(Utf8JsonWriter writer) => ((IJsonModel<SmartGroupData>)this).Write(writer, ModelSerializationExtensions.WireOptions);

        void IJsonModel<SmartGroupData>.Write(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            writer.WriteStartObject();
            JsonModelWriteCore(writer, options);
            writer.WriteEndObject();
        }

        /// <param name="writer"> The JSON writer. </param>
        /// <param name="options"> The client options for reading and writing models. </param>
        protected override void JsonModelWriteCore(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<SmartGroupData>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(SmartGroupData)} does not support writing '{format}' format.");
            }

            base.JsonModelWriteCore(writer, options);
            writer.WritePropertyName("properties"u8);
            writer.WriteStartObject();
            if (Optional.IsDefined(AlertsCount))
            {
                writer.WritePropertyName("alertsCount"u8);
                writer.WriteNumberValue(AlertsCount.Value);
            }
            if (options.Format != "W" && Optional.IsDefined(SmartGroupState))
            {
                writer.WritePropertyName("smartGroupState"u8);
                writer.WriteStringValue(SmartGroupState.Value.ToString());
            }
            if (options.Format != "W" && Optional.IsDefined(Severity))
            {
                writer.WritePropertyName("severity"u8);
                writer.WriteStringValue(Severity.Value.ToString());
            }
            if (options.Format != "W" && Optional.IsDefined(StartOn))
            {
                writer.WritePropertyName("startDateTime"u8);
                writer.WriteStringValue(StartOn.Value, "O");
            }
            if (options.Format != "W" && Optional.IsDefined(LastModifiedOn))
            {
                writer.WritePropertyName("lastModifiedDateTime"u8);
                writer.WriteStringValue(LastModifiedOn.Value, "O");
            }
            if (options.Format != "W" && Optional.IsDefined(LastModifiedBy))
            {
                writer.WritePropertyName("lastModifiedUserName"u8);
                writer.WriteStringValue(LastModifiedBy);
            }
            if (Optional.IsCollectionDefined(Resources))
            {
                writer.WritePropertyName("resources"u8);
                writer.WriteStartArray();
                foreach (var item in Resources)
                {
                    writer.WriteObjectValue(item, options);
                }
                writer.WriteEndArray();
            }
            if (Optional.IsCollectionDefined(ResourceTypes))
            {
                writer.WritePropertyName("resourceTypes"u8);
                writer.WriteStartArray();
                foreach (var item in ResourceTypes)
                {
                    writer.WriteObjectValue(item, options);
                }
                writer.WriteEndArray();
            }
            if (Optional.IsCollectionDefined(ResourceGroups))
            {
                writer.WritePropertyName("resourceGroups"u8);
                writer.WriteStartArray();
                foreach (var item in ResourceGroups)
                {
                    writer.WriteObjectValue(item, options);
                }
                writer.WriteEndArray();
            }
            if (Optional.IsCollectionDefined(MonitorServices))
            {
                writer.WritePropertyName("monitorServices"u8);
                writer.WriteStartArray();
                foreach (var item in MonitorServices)
                {
                    writer.WriteObjectValue(item, options);
                }
                writer.WriteEndArray();
            }
            if (Optional.IsCollectionDefined(MonitorConditions))
            {
                writer.WritePropertyName("monitorConditions"u8);
                writer.WriteStartArray();
                foreach (var item in MonitorConditions)
                {
                    writer.WriteObjectValue(item, options);
                }
                writer.WriteEndArray();
            }
            if (Optional.IsCollectionDefined(AlertStates))
            {
                writer.WritePropertyName("alertStates"u8);
                writer.WriteStartArray();
                foreach (var item in AlertStates)
                {
                    writer.WriteObjectValue(item, options);
                }
                writer.WriteEndArray();
            }
            if (Optional.IsCollectionDefined(AlertSeverities))
            {
                writer.WritePropertyName("alertSeverities"u8);
                writer.WriteStartArray();
                foreach (var item in AlertSeverities)
                {
                    writer.WriteObjectValue(item, options);
                }
                writer.WriteEndArray();
            }
            if (Optional.IsDefined(NextLink))
            {
                writer.WritePropertyName("nextLink"u8);
                writer.WriteStringValue(NextLink);
            }
            writer.WriteEndObject();
        }

        SmartGroupData IJsonModel<SmartGroupData>.Create(ref Utf8JsonReader reader, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<SmartGroupData>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(SmartGroupData)} does not support reading '{format}' format.");
            }

            using JsonDocument document = JsonDocument.ParseValue(ref reader);
            return DeserializeSmartGroupData(document.RootElement, options);
        }

        internal static SmartGroupData DeserializeSmartGroupData(JsonElement element, ModelReaderWriterOptions options = null)
        {
            options ??= ModelSerializationExtensions.WireOptions;

            if (element.ValueKind == JsonValueKind.Null)
            {
                return null;
            }
            ResourceIdentifier id = default;
            string name = default;
            ResourceType type = default;
            SystemData systemData = default;
            long? alertsCount = default;
            SmartGroupState? smartGroupState = default;
            ServiceAlertSeverity? severity = default;
            DateTimeOffset? startDateTime = default;
            DateTimeOffset? lastModifiedDateTime = default;
            string lastModifiedUserName = default;
            IList<SmartGroupAggregatedProperty> resources = default;
            IList<SmartGroupAggregatedProperty> resourceTypes = default;
            IList<SmartGroupAggregatedProperty> resourceGroups = default;
            IList<SmartGroupAggregatedProperty> monitorServices = default;
            IList<SmartGroupAggregatedProperty> monitorConditions = default;
            IList<SmartGroupAggregatedProperty> alertStates = default;
            IList<SmartGroupAggregatedProperty> alertSeverities = default;
            string nextLink = default;
            IDictionary<string, BinaryData> serializedAdditionalRawData = default;
            Dictionary<string, BinaryData> rawDataDictionary = new Dictionary<string, BinaryData>();
            foreach (var property in element.EnumerateObject())
            {
                if (property.NameEquals("id"u8))
                {
                    id = new ResourceIdentifier(property.Value.GetString());
                    continue;
                }
                if (property.NameEquals("name"u8))
                {
                    name = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("type"u8))
                {
                    type = new ResourceType(property.Value.GetString());
                    continue;
                }
                if (property.NameEquals("systemData"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    systemData = JsonSerializer.Deserialize<SystemData>(property.Value.GetRawText());
                    continue;
                }
                if (property.NameEquals("properties"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        property.ThrowNonNullablePropertyIsNull();
                        continue;
                    }
                    foreach (var property0 in property.Value.EnumerateObject())
                    {
                        if (property0.NameEquals("alertsCount"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            alertsCount = property0.Value.GetInt64();
                            continue;
                        }
                        if (property0.NameEquals("smartGroupState"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            smartGroupState = new SmartGroupState(property0.Value.GetString());
                            continue;
                        }
                        if (property0.NameEquals("severity"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            severity = new ServiceAlertSeverity(property0.Value.GetString());
                            continue;
                        }
                        if (property0.NameEquals("startDateTime"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            startDateTime = property0.Value.GetDateTimeOffset("O");
                            continue;
                        }
                        if (property0.NameEquals("lastModifiedDateTime"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            lastModifiedDateTime = property0.Value.GetDateTimeOffset("O");
                            continue;
                        }
                        if (property0.NameEquals("lastModifiedUserName"u8))
                        {
                            lastModifiedUserName = property0.Value.GetString();
                            continue;
                        }
                        if (property0.NameEquals("resources"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            List<SmartGroupAggregatedProperty> array = new List<SmartGroupAggregatedProperty>();
                            foreach (var item in property0.Value.EnumerateArray())
                            {
                                array.Add(SmartGroupAggregatedProperty.DeserializeSmartGroupAggregatedProperty(item, options));
                            }
                            resources = array;
                            continue;
                        }
                        if (property0.NameEquals("resourceTypes"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            List<SmartGroupAggregatedProperty> array = new List<SmartGroupAggregatedProperty>();
                            foreach (var item in property0.Value.EnumerateArray())
                            {
                                array.Add(SmartGroupAggregatedProperty.DeserializeSmartGroupAggregatedProperty(item, options));
                            }
                            resourceTypes = array;
                            continue;
                        }
                        if (property0.NameEquals("resourceGroups"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            List<SmartGroupAggregatedProperty> array = new List<SmartGroupAggregatedProperty>();
                            foreach (var item in property0.Value.EnumerateArray())
                            {
                                array.Add(SmartGroupAggregatedProperty.DeserializeSmartGroupAggregatedProperty(item, options));
                            }
                            resourceGroups = array;
                            continue;
                        }
                        if (property0.NameEquals("monitorServices"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            List<SmartGroupAggregatedProperty> array = new List<SmartGroupAggregatedProperty>();
                            foreach (var item in property0.Value.EnumerateArray())
                            {
                                array.Add(SmartGroupAggregatedProperty.DeserializeSmartGroupAggregatedProperty(item, options));
                            }
                            monitorServices = array;
                            continue;
                        }
                        if (property0.NameEquals("monitorConditions"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            List<SmartGroupAggregatedProperty> array = new List<SmartGroupAggregatedProperty>();
                            foreach (var item in property0.Value.EnumerateArray())
                            {
                                array.Add(SmartGroupAggregatedProperty.DeserializeSmartGroupAggregatedProperty(item, options));
                            }
                            monitorConditions = array;
                            continue;
                        }
                        if (property0.NameEquals("alertStates"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            List<SmartGroupAggregatedProperty> array = new List<SmartGroupAggregatedProperty>();
                            foreach (var item in property0.Value.EnumerateArray())
                            {
                                array.Add(SmartGroupAggregatedProperty.DeserializeSmartGroupAggregatedProperty(item, options));
                            }
                            alertStates = array;
                            continue;
                        }
                        if (property0.NameEquals("alertSeverities"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            List<SmartGroupAggregatedProperty> array = new List<SmartGroupAggregatedProperty>();
                            foreach (var item in property0.Value.EnumerateArray())
                            {
                                array.Add(SmartGroupAggregatedProperty.DeserializeSmartGroupAggregatedProperty(item, options));
                            }
                            alertSeverities = array;
                            continue;
                        }
                        if (property0.NameEquals("nextLink"u8))
                        {
                            nextLink = property0.Value.GetString();
                            continue;
                        }
                    }
                    continue;
                }
                if (options.Format != "W")
                {
                    rawDataDictionary.Add(property.Name, BinaryData.FromString(property.Value.GetRawText()));
                }
            }
            serializedAdditionalRawData = rawDataDictionary;
            return new SmartGroupData(
                id,
                name,
                type,
                systemData,
                alertsCount,
                smartGroupState,
                severity,
                startDateTime,
                lastModifiedDateTime,
                lastModifiedUserName,
                resources ?? new ChangeTrackingList<SmartGroupAggregatedProperty>(),
                resourceTypes ?? new ChangeTrackingList<SmartGroupAggregatedProperty>(),
                resourceGroups ?? new ChangeTrackingList<SmartGroupAggregatedProperty>(),
                monitorServices ?? new ChangeTrackingList<SmartGroupAggregatedProperty>(),
                monitorConditions ?? new ChangeTrackingList<SmartGroupAggregatedProperty>(),
                alertStates ?? new ChangeTrackingList<SmartGroupAggregatedProperty>(),
                alertSeverities ?? new ChangeTrackingList<SmartGroupAggregatedProperty>(),
                nextLink,
                serializedAdditionalRawData);
        }

        BinaryData IPersistableModel<SmartGroupData>.Write(ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<SmartGroupData>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    return ModelReaderWriter.Write(this, options);
                default:
                    throw new FormatException($"The model {nameof(SmartGroupData)} does not support writing '{options.Format}' format.");
            }
        }

        SmartGroupData IPersistableModel<SmartGroupData>.Create(BinaryData data, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<SmartGroupData>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    {
                        using JsonDocument document = JsonDocument.Parse(data);
                        return DeserializeSmartGroupData(document.RootElement, options);
                    }
                default:
                    throw new FormatException($"The model {nameof(SmartGroupData)} does not support reading '{options.Format}' format.");
            }
        }

        string IPersistableModel<SmartGroupData>.GetFormatFromOptions(ModelReaderWriterOptions options) => "J";
    }
}
