// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.AlertsManagement.Models
{
    /// <summary> The SmartGroupsSortByField. </summary>
    public readonly partial struct SmartGroupsSortByField : IEquatable<SmartGroupsSortByField>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="SmartGroupsSortByField"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public SmartGroupsSortByField(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string AlertsCountValue = "alertsCount";
        private const string StateValue = "state";
        private const string SeverityValue = "severity";
        private const string StartDateTimeValue = "startDateTime";
        private const string LastModifiedDateTimeValue = "lastModifiedDateTime";

        /// <summary> alertsCount. </summary>
        public static SmartGroupsSortByField AlertsCount { get; } = new SmartGroupsSortByField(AlertsCountValue);
        /// <summary> state. </summary>
        public static SmartGroupsSortByField State { get; } = new SmartGroupsSortByField(StateValue);
        /// <summary> severity. </summary>
        public static SmartGroupsSortByField Severity { get; } = new SmartGroupsSortByField(SeverityValue);
        /// <summary> startDateTime. </summary>
        public static SmartGroupsSortByField StartDateTime { get; } = new SmartGroupsSortByField(StartDateTimeValue);
        /// <summary> lastModifiedDateTime. </summary>
        public static SmartGroupsSortByField LastModifiedDateTime { get; } = new SmartGroupsSortByField(LastModifiedDateTimeValue);
        /// <summary> Determines if two <see cref="SmartGroupsSortByField"/> values are the same. </summary>
        public static bool operator ==(SmartGroupsSortByField left, SmartGroupsSortByField right) => left.Equals(right);
        /// <summary> Determines if two <see cref="SmartGroupsSortByField"/> values are not the same. </summary>
        public static bool operator !=(SmartGroupsSortByField left, SmartGroupsSortByField right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="SmartGroupsSortByField"/>. </summary>
        public static implicit operator SmartGroupsSortByField(string value) => new SmartGroupsSortByField(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is SmartGroupsSortByField other && Equals(other);
        /// <inheritdoc />
        public bool Equals(SmartGroupsSortByField other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
