// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.AlertsManagement.Models
{
    /// <summary> Smart group state. </summary>
    public readonly partial struct SmartGroupState : IEquatable<SmartGroupState>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="SmartGroupState"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public SmartGroupState(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string NewValue = "New";
        private const string AcknowledgedValue = "Acknowledged";
        private const string ClosedValue = "Closed";

        /// <summary> New. </summary>
        public static SmartGroupState New { get; } = new SmartGroupState(NewValue);
        /// <summary> Acknowledged. </summary>
        public static SmartGroupState Acknowledged { get; } = new SmartGroupState(AcknowledgedValue);
        /// <summary> Closed. </summary>
        public static SmartGroupState Closed { get; } = new SmartGroupState(ClosedValue);
        /// <summary> Determines if two <see cref="SmartGroupState"/> values are the same. </summary>
        public static bool operator ==(SmartGroupState left, SmartGroupState right) => left.Equals(right);
        /// <summary> Determines if two <see cref="SmartGroupState"/> values are not the same. </summary>
        public static bool operator !=(SmartGroupState left, SmartGroupState right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="SmartGroupState"/>. </summary>
        public static implicit operator SmartGroupState(string value) => new SmartGroupState(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is SmartGroupState other && Equals(other);
        /// <inheritdoc />
        public bool Equals(SmartGroupState other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
