// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;

namespace Azure.ResourceManager.AlertsManagement.Models
{
    internal static partial class SmartGroupModificationEventExtensions
    {
        public static string ToSerialString(this SmartGroupModificationEvent value) => value switch
        {
            SmartGroupModificationEvent.SmartGroupCreated => "SmartGroupCreated",
            SmartGroupModificationEvent.StateChange => "StateChange",
            SmartGroupModificationEvent.AlertAdded => "AlertAdded",
            SmartGroupModificationEvent.AlertRemoved => "AlertRemoved",
            _ => throw new ArgumentOutOfRangeException(nameof(value), value, "Unknown SmartGroupModificationEvent value.")
        };

        public static SmartGroupModificationEvent ToSmartGroupModificationEvent(this string value)
        {
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "SmartGroupCreated")) return SmartGroupModificationEvent.SmartGroupCreated;
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "StateChange")) return SmartGroupModificationEvent.StateChange;
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "AlertAdded")) return SmartGroupModificationEvent.AlertAdded;
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "AlertRemoved")) return SmartGroupModificationEvent.AlertRemoved;
            throw new ArgumentOutOfRangeException(nameof(value), value, "Unknown SmartGroupModificationEvent value.");
        }
    }
}
