// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.AlertsManagement.Models
{
    /// <summary> Group the result set. </summary>
    public partial class ServiceAlertSummaryGroup
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="ServiceAlertSummaryGroup"/>. </summary>
        public ServiceAlertSummaryGroup()
        {
            Values = new ChangeTrackingList<ServiceAlertSummaryGroupItemInfo>();
        }

        /// <summary> Initializes a new instance of <see cref="ServiceAlertSummaryGroup"/>. </summary>
        /// <param name="total"> Total count of the result set. </param>
        /// <param name="smartGroupsCount"> Total count of the smart groups. </param>
        /// <param name="groupedBy"> Name of the field aggregated. </param>
        /// <param name="values"> List of the items. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal ServiceAlertSummaryGroup(long? total, long? smartGroupsCount, string groupedBy, IList<ServiceAlertSummaryGroupItemInfo> values, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            Total = total;
            SmartGroupsCount = smartGroupsCount;
            GroupedBy = groupedBy;
            Values = values;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Total count of the result set. </summary>
        public long? Total { get; set; }
        /// <summary> Total count of the smart groups. </summary>
        public long? SmartGroupsCount { get; set; }
        /// <summary> Name of the field aggregated. </summary>
        public string GroupedBy { get; set; }
        /// <summary> List of the items. </summary>
        public IList<ServiceAlertSummaryGroupItemInfo> Values { get; }
    }
}
