// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.AlertsManagement.Models
{
    /// <summary> The ServiceAlertState. </summary>
    public readonly partial struct ServiceAlertState : IEquatable<ServiceAlertState>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="ServiceAlertState"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public ServiceAlertState(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string NewValue = "New";
        private const string AcknowledgedValue = "Acknowledged";
        private const string ClosedValue = "Closed";

        /// <summary> New. </summary>
        public static ServiceAlertState New { get; } = new ServiceAlertState(NewValue);
        /// <summary> Acknowledged. </summary>
        public static ServiceAlertState Acknowledged { get; } = new ServiceAlertState(AcknowledgedValue);
        /// <summary> Closed. </summary>
        public static ServiceAlertState Closed { get; } = new ServiceAlertState(ClosedValue);
        /// <summary> Determines if two <see cref="ServiceAlertState"/> values are the same. </summary>
        public static bool operator ==(ServiceAlertState left, ServiceAlertState right) => left.Equals(right);
        /// <summary> Determines if two <see cref="ServiceAlertState"/> values are not the same. </summary>
        public static bool operator !=(ServiceAlertState left, ServiceAlertState right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="ServiceAlertState"/>. </summary>
        public static implicit operator ServiceAlertState(string value) => new ServiceAlertState(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is ServiceAlertState other && Equals(other);
        /// <inheritdoc />
        public bool Equals(ServiceAlertState other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
