// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ClientModel.Primitives;
using System.Collections.Generic;
using System.Text.Json;
using Azure.Core;

namespace Azure.ResourceManager.AlertsManagement.Models
{
    public partial class ServiceAlertProperties : IUtf8JsonSerializable, IJsonModel<ServiceAlertProperties>
    {
        void IUtf8JsonSerializable.Write(Utf8JsonWriter writer) => ((IJsonModel<ServiceAlertProperties>)this).Write(writer, ModelSerializationExtensions.WireOptions);

        void IJsonModel<ServiceAlertProperties>.Write(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            writer.WriteStartObject();
            JsonModelWriteCore(writer, options);
            writer.WriteEndObject();
        }

        /// <param name="writer"> The JSON writer. </param>
        /// <param name="options"> The client options for reading and writing models. </param>
        protected virtual void JsonModelWriteCore(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<ServiceAlertProperties>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(ServiceAlertProperties)} does not support writing '{format}' format.");
            }

            if (Optional.IsDefined(Essentials))
            {
                writer.WritePropertyName("essentials"u8);
                writer.WriteObjectValue(Essentials, options);
            }
            if (options.Format != "W" && Optional.IsDefined(Context))
            {
                writer.WritePropertyName("context"u8);
#if NET6_0_OR_GREATER
				writer.WriteRawValue(Context);
#else
                using (JsonDocument document = JsonDocument.Parse(Context))
                {
                    JsonSerializer.Serialize(writer, document.RootElement);
                }
#endif
            }
            if (options.Format != "W" && Optional.IsDefined(EgressConfig))
            {
                writer.WritePropertyName("egressConfig"u8);
#if NET6_0_OR_GREATER
				writer.WriteRawValue(EgressConfig);
#else
                using (JsonDocument document = JsonDocument.Parse(EgressConfig))
                {
                    JsonSerializer.Serialize(writer, document.RootElement);
                }
#endif
            }
            if (options.Format != "W" && _serializedAdditionalRawData != null)
            {
                foreach (var item in _serializedAdditionalRawData)
                {
                    writer.WritePropertyName(item.Key);
#if NET6_0_OR_GREATER
				writer.WriteRawValue(item.Value);
#else
                    using (JsonDocument document = JsonDocument.Parse(item.Value))
                    {
                        JsonSerializer.Serialize(writer, document.RootElement);
                    }
#endif
                }
            }
        }

        ServiceAlertProperties IJsonModel<ServiceAlertProperties>.Create(ref Utf8JsonReader reader, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<ServiceAlertProperties>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(ServiceAlertProperties)} does not support reading '{format}' format.");
            }

            using JsonDocument document = JsonDocument.ParseValue(ref reader);
            return DeserializeServiceAlertProperties(document.RootElement, options);
        }

        internal static ServiceAlertProperties DeserializeServiceAlertProperties(JsonElement element, ModelReaderWriterOptions options = null)
        {
            options ??= ModelSerializationExtensions.WireOptions;

            if (element.ValueKind == JsonValueKind.Null)
            {
                return null;
            }
            ServiceAlertEssentials essentials = default;
            BinaryData context = default;
            BinaryData egressConfig = default;
            IDictionary<string, BinaryData> serializedAdditionalRawData = default;
            Dictionary<string, BinaryData> rawDataDictionary = new Dictionary<string, BinaryData>();
            foreach (var property in element.EnumerateObject())
            {
                if (property.NameEquals("essentials"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    essentials = ServiceAlertEssentials.DeserializeServiceAlertEssentials(property.Value, options);
                    continue;
                }
                if (property.NameEquals("context"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    context = BinaryData.FromString(property.Value.GetRawText());
                    continue;
                }
                if (property.NameEquals("egressConfig"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    egressConfig = BinaryData.FromString(property.Value.GetRawText());
                    continue;
                }
                if (options.Format != "W")
                {
                    rawDataDictionary.Add(property.Name, BinaryData.FromString(property.Value.GetRawText()));
                }
            }
            serializedAdditionalRawData = rawDataDictionary;
            return new ServiceAlertProperties(essentials, context, egressConfig, serializedAdditionalRawData);
        }

        BinaryData IPersistableModel<ServiceAlertProperties>.Write(ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<ServiceAlertProperties>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    return ModelReaderWriter.Write(this, options);
                default:
                    throw new FormatException($"The model {nameof(ServiceAlertProperties)} does not support writing '{options.Format}' format.");
            }
        }

        ServiceAlertProperties IPersistableModel<ServiceAlertProperties>.Create(BinaryData data, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<ServiceAlertProperties>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    {
                        using JsonDocument document = JsonDocument.Parse(data);
                        return DeserializeServiceAlertProperties(document.RootElement, options);
                    }
                default:
                    throw new FormatException($"The model {nameof(ServiceAlertProperties)} does not support reading '{options.Format}' format.");
            }
        }

        string IPersistableModel<ServiceAlertProperties>.GetFormatFromOptions(ModelReaderWriterOptions options) => "J";
    }
}
