// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.AlertsManagement.Models
{
    /// <summary> Alert modification item. </summary>
    public partial class ServiceAlertModificationItemInfo
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="ServiceAlertModificationItemInfo"/>. </summary>
        public ServiceAlertModificationItemInfo()
        {
        }

        /// <summary> Initializes a new instance of <see cref="ServiceAlertModificationItemInfo"/>. </summary>
        /// <param name="modificationEvent"> Reason for the modification. </param>
        /// <param name="oldValue"> Old value. </param>
        /// <param name="newValue"> New value. </param>
        /// <param name="modifiedAt"> Modified date and time. </param>
        /// <param name="modifiedBy"> Modified user details (Principal client name). </param>
        /// <param name="comments"> Modification comments. </param>
        /// <param name="description"> Description of the modification. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal ServiceAlertModificationItemInfo(ServiceAlertModificationEvent? modificationEvent, string oldValue, string newValue, string modifiedAt, string modifiedBy, string comments, string description, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            ModificationEvent = modificationEvent;
            OldValue = oldValue;
            NewValue = newValue;
            ModifiedAt = modifiedAt;
            ModifiedBy = modifiedBy;
            Comments = comments;
            Description = description;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Reason for the modification. </summary>
        public ServiceAlertModificationEvent? ModificationEvent { get; set; }
        /// <summary> Old value. </summary>
        public string OldValue { get; set; }
        /// <summary> New value. </summary>
        public string NewValue { get; set; }
        /// <summary> Modified date and time. </summary>
        public string ModifiedAt { get; set; }
        /// <summary> Modified user details (Principal client name). </summary>
        public string ModifiedBy { get; set; }
        /// <summary> Modification comments. </summary>
        public string Comments { get; set; }
        /// <summary> Description of the modification. </summary>
        public string Description { get; set; }
    }
}
