// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;

namespace Azure.ResourceManager.AlertsManagement.Models
{
    internal static partial class ServiceAlertModificationEventExtensions
    {
        public static string ToSerialString(this ServiceAlertModificationEvent value) => value switch
        {
            ServiceAlertModificationEvent.AlertCreated => "AlertCreated",
            ServiceAlertModificationEvent.StateChange => "StateChange",
            ServiceAlertModificationEvent.MonitorConditionChange => "MonitorConditionChange",
            ServiceAlertModificationEvent.SeverityChange => "SeverityChange",
            ServiceAlertModificationEvent.ActionRuleTriggered => "ActionRuleTriggered",
            ServiceAlertModificationEvent.ActionRuleSuppressed => "ActionRuleSuppressed",
            ServiceAlertModificationEvent.ActionsTriggered => "ActionsTriggered",
            ServiceAlertModificationEvent.ActionsSuppressed => "ActionsSuppressed",
            ServiceAlertModificationEvent.ActionsFailed => "ActionsFailed",
            _ => throw new ArgumentOutOfRangeException(nameof(value), value, "Unknown ServiceAlertModificationEvent value.")
        };

        public static ServiceAlertModificationEvent ToServiceAlertModificationEvent(this string value)
        {
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "AlertCreated")) return ServiceAlertModificationEvent.AlertCreated;
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "StateChange")) return ServiceAlertModificationEvent.StateChange;
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "MonitorConditionChange")) return ServiceAlertModificationEvent.MonitorConditionChange;
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "SeverityChange")) return ServiceAlertModificationEvent.SeverityChange;
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "ActionRuleTriggered")) return ServiceAlertModificationEvent.ActionRuleTriggered;
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "ActionRuleSuppressed")) return ServiceAlertModificationEvent.ActionRuleSuppressed;
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "ActionsTriggered")) return ServiceAlertModificationEvent.ActionsTriggered;
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "ActionsSuppressed")) return ServiceAlertModificationEvent.ActionsSuppressed;
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "ActionsFailed")) return ServiceAlertModificationEvent.ActionsFailed;
            throw new ArgumentOutOfRangeException(nameof(value), value, "Unknown ServiceAlertModificationEvent value.");
        }
    }
}
