// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.AlertsManagement.Models
{
    /// <summary> Identification of the information to be retrieved by API call. </summary>
    internal readonly partial struct ServiceAlertMetadataIdentifier : IEquatable<ServiceAlertMetadataIdentifier>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="ServiceAlertMetadataIdentifier"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public ServiceAlertMetadataIdentifier(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string MonitorServiceListValue = "MonitorServiceList";

        /// <summary> MonitorServiceList. </summary>
        public static ServiceAlertMetadataIdentifier MonitorServiceList { get; } = new ServiceAlertMetadataIdentifier(MonitorServiceListValue);
        /// <summary> Determines if two <see cref="ServiceAlertMetadataIdentifier"/> values are the same. </summary>
        public static bool operator ==(ServiceAlertMetadataIdentifier left, ServiceAlertMetadataIdentifier right) => left.Equals(right);
        /// <summary> Determines if two <see cref="ServiceAlertMetadataIdentifier"/> values are not the same. </summary>
        public static bool operator !=(ServiceAlertMetadataIdentifier left, ServiceAlertMetadataIdentifier right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="ServiceAlertMetadataIdentifier"/>. </summary>
        public static implicit operator ServiceAlertMetadataIdentifier(string value) => new ServiceAlertMetadataIdentifier(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is ServiceAlertMetadataIdentifier other && Equals(other);
        /// <inheritdoc />
        public bool Equals(ServiceAlertMetadataIdentifier other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
