// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.AlertsManagement.Models
{
    /// <summary> The RetrievedInformationIdentifier. </summary>
    public readonly partial struct RetrievedInformationIdentifier : IEquatable<RetrievedInformationIdentifier>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="RetrievedInformationIdentifier"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public RetrievedInformationIdentifier(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string MonitorServiceListValue = "MonitorServiceList";

        /// <summary> MonitorServiceList. </summary>
        public static RetrievedInformationIdentifier MonitorServiceList { get; } = new RetrievedInformationIdentifier(MonitorServiceListValue);
        /// <summary> Determines if two <see cref="RetrievedInformationIdentifier"/> values are the same. </summary>
        public static bool operator ==(RetrievedInformationIdentifier left, RetrievedInformationIdentifier right) => left.Equals(right);
        /// <summary> Determines if two <see cref="RetrievedInformationIdentifier"/> values are not the same. </summary>
        public static bool operator !=(RetrievedInformationIdentifier left, RetrievedInformationIdentifier right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="RetrievedInformationIdentifier"/>. </summary>
        public static implicit operator RetrievedInformationIdentifier(string value) => new RetrievedInformationIdentifier(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is RetrievedInformationIdentifier other && Equals(other);
        /// <inheritdoc />
        public bool Equals(RetrievedInformationIdentifier other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
