// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.AlertsManagement.Models
{
    /// <summary> Specifies when the recurrence should be applied. </summary>
    internal readonly partial struct RecurrenceType : IEquatable<RecurrenceType>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="RecurrenceType"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public RecurrenceType(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string DailyValue = "Daily";
        private const string WeeklyValue = "Weekly";
        private const string MonthlyValue = "Monthly";

        /// <summary> Daily. </summary>
        public static RecurrenceType Daily { get; } = new RecurrenceType(DailyValue);
        /// <summary> Weekly. </summary>
        public static RecurrenceType Weekly { get; } = new RecurrenceType(WeeklyValue);
        /// <summary> Monthly. </summary>
        public static RecurrenceType Monthly { get; } = new RecurrenceType(MonthlyValue);
        /// <summary> Determines if two <see cref="RecurrenceType"/> values are the same. </summary>
        public static bool operator ==(RecurrenceType left, RecurrenceType right) => left.Equals(right);
        /// <summary> Determines if two <see cref="RecurrenceType"/> values are not the same. </summary>
        public static bool operator !=(RecurrenceType left, RecurrenceType right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="RecurrenceType"/>. </summary>
        public static implicit operator RecurrenceType(string value) => new RecurrenceType(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is RecurrenceType other && Equals(other);
        /// <inheritdoc />
        public bool Equals(RecurrenceType other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
