// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.AlertsManagement.Models
{
    /// <summary> The MonitorCondition. </summary>
    public readonly partial struct MonitorCondition : IEquatable<MonitorCondition>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="MonitorCondition"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public MonitorCondition(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string FiredValue = "Fired";
        private const string ResolvedValue = "Resolved";

        /// <summary> Fired. </summary>
        public static MonitorCondition Fired { get; } = new MonitorCondition(FiredValue);
        /// <summary> Resolved. </summary>
        public static MonitorCondition Resolved { get; } = new MonitorCondition(ResolvedValue);
        /// <summary> Determines if two <see cref="MonitorCondition"/> values are the same. </summary>
        public static bool operator ==(MonitorCondition left, MonitorCondition right) => left.Equals(right);
        /// <summary> Determines if two <see cref="MonitorCondition"/> values are not the same. </summary>
        public static bool operator !=(MonitorCondition left, MonitorCondition right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="MonitorCondition"/>. </summary>
        public static implicit operator MonitorCondition(string value) => new MonitorCondition(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is MonitorCondition other && Equals(other);
        /// <inheritdoc />
        public bool Equals(MonitorCondition other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
