// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;
using System.Linq;

namespace Azure.ResourceManager.AlertsManagement.Models
{
    /// <summary> Weekly recurrence object. </summary>
    public partial class AlertProcessingRuleWeeklyRecurrence : AlertProcessingRuleRecurrence
    {
        /// <summary> Initializes a new instance of <see cref="AlertProcessingRuleWeeklyRecurrence"/>. </summary>
        /// <param name="daysOfWeek"> Specifies the values for weekly recurrence pattern. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="daysOfWeek"/> is null. </exception>
        public AlertProcessingRuleWeeklyRecurrence(IEnumerable<AlertsManagementDayOfWeek> daysOfWeek)
        {
            Argument.AssertNotNull(daysOfWeek, nameof(daysOfWeek));

            DaysOfWeek = daysOfWeek.ToList();
            RecurrenceType = RecurrenceType.Weekly;
        }

        /// <summary> Initializes a new instance of <see cref="AlertProcessingRuleWeeklyRecurrence"/>. </summary>
        /// <param name="recurrenceType"> Specifies when the recurrence should be applied. </param>
        /// <param name="startOn"> Start time for recurrence. </param>
        /// <param name="endOn"> End time for recurrence. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        /// <param name="daysOfWeek"> Specifies the values for weekly recurrence pattern. </param>
        internal AlertProcessingRuleWeeklyRecurrence(RecurrenceType recurrenceType, TimeSpan? startOn, TimeSpan? endOn, IDictionary<string, BinaryData> serializedAdditionalRawData, IList<AlertsManagementDayOfWeek> daysOfWeek) : base(recurrenceType, startOn, endOn, serializedAdditionalRawData)
        {
            DaysOfWeek = daysOfWeek;
            RecurrenceType = recurrenceType;
        }

        /// <summary> Initializes a new instance of <see cref="AlertProcessingRuleWeeklyRecurrence"/> for deserialization. </summary>
        internal AlertProcessingRuleWeeklyRecurrence()
        {
        }

        /// <summary> Specifies the values for weekly recurrence pattern. </summary>
        public IList<AlertsManagementDayOfWeek> DaysOfWeek { get; }
    }
}
