// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.AlertsManagement.Models
{
    /// <summary> Scheduling configuration for a given alert processing rule. </summary>
    public partial class AlertProcessingRuleSchedule
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="AlertProcessingRuleSchedule"/>. </summary>
        public AlertProcessingRuleSchedule()
        {
            Recurrences = new ChangeTrackingList<AlertProcessingRuleRecurrence>();
        }

        /// <summary> Initializes a new instance of <see cref="AlertProcessingRuleSchedule"/>. </summary>
        /// <param name="effectiveFrom"> Scheduling effective from time. Date-Time in ISO-8601 format without timezone suffix. </param>
        /// <param name="effectiveUntil"> Scheduling effective until time. Date-Time in ISO-8601 format without timezone suffix. </param>
        /// <param name="timeZone"> Scheduling time zone. </param>
        /// <param name="recurrences">
        /// List of recurrences.
        /// Please note <see cref="AlertProcessingRuleRecurrence"/> is the base class. According to the scenario, a derived class of the base class might need to be assigned here, or this property needs to be casted to one of the possible derived classes.
        /// The available derived classes include <see cref="DailyRecurrence"/>, <see cref="AlertProcessingRuleMonthlyRecurrence"/> and <see cref="AlertProcessingRuleWeeklyRecurrence"/>.
        /// </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal AlertProcessingRuleSchedule(DateTimeOffset? effectiveFrom, DateTimeOffset? effectiveUntil, string timeZone, IList<AlertProcessingRuleRecurrence> recurrences, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            EffectiveFrom = effectiveFrom;
            EffectiveUntil = effectiveUntil;
            TimeZone = timeZone;
            Recurrences = recurrences;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Scheduling effective from time. Date-Time in ISO-8601 format without timezone suffix. </summary>
        public DateTimeOffset? EffectiveFrom { get; set; }
        /// <summary> Scheduling effective until time. Date-Time in ISO-8601 format without timezone suffix. </summary>
        public DateTimeOffset? EffectiveUntil { get; set; }
        /// <summary> Scheduling time zone. </summary>
        public string TimeZone { get; set; }
        /// <summary>
        /// List of recurrences.
        /// Please note <see cref="AlertProcessingRuleRecurrence"/> is the base class. According to the scenario, a derived class of the base class might need to be assigned here, or this property needs to be casted to one of the possible derived classes.
        /// The available derived classes include <see cref="DailyRecurrence"/>, <see cref="AlertProcessingRuleMonthlyRecurrence"/> and <see cref="AlertProcessingRuleWeeklyRecurrence"/>.
        /// </summary>
        public IList<AlertProcessingRuleRecurrence> Recurrences { get; }
    }
}
