// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;
using System.Linq;
using Azure.Core;

namespace Azure.ResourceManager.AlertsManagement.Models
{
    /// <summary> Add action groups to alert processing rule. </summary>
    public partial class AlertProcessingRuleAddGroupsAction : AlertProcessingRuleAction
    {
        /// <summary> Initializes a new instance of <see cref="AlertProcessingRuleAddGroupsAction"/>. </summary>
        /// <param name="actionGroupIds"> List of action group Ids to add to alert processing rule. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="actionGroupIds"/> is null. </exception>
        public AlertProcessingRuleAddGroupsAction(IEnumerable<ResourceIdentifier> actionGroupIds)
        {
            Argument.AssertNotNull(actionGroupIds, nameof(actionGroupIds));

            ActionGroupIds = actionGroupIds.ToList();
            ActionType = AlertProcessingRuleActionType.AddActionGroups;
        }

        /// <summary> Initializes a new instance of <see cref="AlertProcessingRuleAddGroupsAction"/>. </summary>
        /// <param name="actionType"> Action that should be applied. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        /// <param name="actionGroupIds"> List of action group Ids to add to alert processing rule. </param>
        internal AlertProcessingRuleAddGroupsAction(AlertProcessingRuleActionType actionType, IDictionary<string, BinaryData> serializedAdditionalRawData, IList<ResourceIdentifier> actionGroupIds) : base(actionType, serializedAdditionalRawData)
        {
            ActionGroupIds = actionGroupIds;
            ActionType = actionType;
        }

        /// <summary> Initializes a new instance of <see cref="AlertProcessingRuleAddGroupsAction"/> for deserialization. </summary>
        internal AlertProcessingRuleAddGroupsAction()
        {
        }

        /// <summary> List of action group Ids to add to alert processing rule. </summary>
        public IList<ResourceIdentifier> ActionGroupIds { get; }
    }
}
