// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.AlertsManagement.Models
{
    /// <summary> Action that should be applied. </summary>
    internal readonly partial struct AlertProcessingRuleActionType : IEquatable<AlertProcessingRuleActionType>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="AlertProcessingRuleActionType"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public AlertProcessingRuleActionType(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string AddActionGroupsValue = "AddActionGroups";
        private const string RemoveAllActionGroupsValue = "RemoveAllActionGroups";

        /// <summary> AddActionGroups. </summary>
        public static AlertProcessingRuleActionType AddActionGroups { get; } = new AlertProcessingRuleActionType(AddActionGroupsValue);
        /// <summary> RemoveAllActionGroups. </summary>
        public static AlertProcessingRuleActionType RemoveAllActionGroups { get; } = new AlertProcessingRuleActionType(RemoveAllActionGroupsValue);
        /// <summary> Determines if two <see cref="AlertProcessingRuleActionType"/> values are the same. </summary>
        public static bool operator ==(AlertProcessingRuleActionType left, AlertProcessingRuleActionType right) => left.Equals(right);
        /// <summary> Determines if two <see cref="AlertProcessingRuleActionType"/> values are not the same. </summary>
        public static bool operator !=(AlertProcessingRuleActionType left, AlertProcessingRuleActionType right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="AlertProcessingRuleActionType"/>. </summary>
        public static implicit operator AlertProcessingRuleActionType(string value) => new AlertProcessingRuleActionType(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is AlertProcessingRuleActionType other && Equals(other);
        /// <inheritdoc />
        public bool Equals(AlertProcessingRuleActionType other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
