// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Threading;
using System.Threading.Tasks;
using Azure.Core;
using Azure.Core.Pipeline;
using Azure.ResourceManager.AlertsManagement.Models;

namespace Azure.ResourceManager.AlertsManagement.Mocking
{
    /// <summary> A class to add extension methods to TenantResource. </summary>
    public partial class MockableAlertsManagementTenantResource : ArmResource
    {
        private ClientDiagnostics _serviceAlertAlertsClientDiagnostics;
        private AlertsRestOperations _serviceAlertAlertsRestClient;

        /// <summary> Initializes a new instance of the <see cref="MockableAlertsManagementTenantResource"/> class for mocking. </summary>
        protected MockableAlertsManagementTenantResource()
        {
        }

        /// <summary> Initializes a new instance of the <see cref="MockableAlertsManagementTenantResource"/> class. </summary>
        /// <param name="client"> The client parameters to use in these operations. </param>
        /// <param name="id"> The identifier of the resource that is the target of operations. </param>
        internal MockableAlertsManagementTenantResource(ArmClient client, ResourceIdentifier id) : base(client, id)
        {
        }

        private ClientDiagnostics ServiceAlertAlertsClientDiagnostics => _serviceAlertAlertsClientDiagnostics ??= new ClientDiagnostics("Azure.ResourceManager.AlertsManagement", ServiceAlertResource.ResourceType.Namespace, Diagnostics);
        private AlertsRestOperations ServiceAlertAlertsRestClient => _serviceAlertAlertsRestClient ??= new AlertsRestOperations(Pipeline, Diagnostics.ApplicationId, Endpoint, GetApiVersionOrNull(ServiceAlertResource.ResourceType));

        private string GetApiVersionOrNull(ResourceType resourceType)
        {
            TryGetApiVersion(resourceType, out string apiVersion);
            return apiVersion;
        }

        /// <summary>
        /// List alerts meta data information based on value of identifier parameter.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/providers/Microsoft.AlertsManagement/alertsMetaData</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>Alerts_MetaData</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2019-05-05-preview</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="ServiceAlertResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="identifier"> Identification of the information to be retrieved by API call. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        public virtual async Task<Response<ServiceAlertMetadata>> GetServiceAlertMetadataAsync(RetrievedInformationIdentifier identifier, CancellationToken cancellationToken = default)
        {
            using var scope = ServiceAlertAlertsClientDiagnostics.CreateScope("MockableAlertsManagementTenantResource.GetServiceAlertMetadata");
            scope.Start();
            try
            {
                var response = await ServiceAlertAlertsRestClient.MetaDataAsync(identifier, cancellationToken).ConfigureAwait(false);
                return response;
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// List alerts meta data information based on value of identifier parameter.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/providers/Microsoft.AlertsManagement/alertsMetaData</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>Alerts_MetaData</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2019-05-05-preview</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="ServiceAlertResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="identifier"> Identification of the information to be retrieved by API call. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        public virtual Response<ServiceAlertMetadata> GetServiceAlertMetadata(RetrievedInformationIdentifier identifier, CancellationToken cancellationToken = default)
        {
            using var scope = ServiceAlertAlertsClientDiagnostics.CreateScope("MockableAlertsManagementTenantResource.GetServiceAlertMetadata");
            scope.Start();
            try
            {
                var response = ServiceAlertAlertsRestClient.MetaData(identifier, cancellationToken);
                return response;
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }
    }
}
