// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Threading;
using System.Threading.Tasks;
using Azure.Core;

namespace Azure.ResourceManager.AlertsManagement.Mocking
{
    /// <summary> A class to add extension methods to ResourceGroupResource. </summary>
    public partial class MockableAlertsManagementResourceGroupResource : ArmResource
    {
        /// <summary> Initializes a new instance of the <see cref="MockableAlertsManagementResourceGroupResource"/> class for mocking. </summary>
        protected MockableAlertsManagementResourceGroupResource()
        {
        }

        /// <summary> Initializes a new instance of the <see cref="MockableAlertsManagementResourceGroupResource"/> class. </summary>
        /// <param name="client"> The client parameters to use in these operations. </param>
        /// <param name="id"> The identifier of the resource that is the target of operations. </param>
        internal MockableAlertsManagementResourceGroupResource(ArmClient client, ResourceIdentifier id) : base(client, id)
        {
        }

        private string GetApiVersionOrNull(ResourceType resourceType)
        {
            TryGetApiVersion(resourceType, out string apiVersion);
            return apiVersion;
        }

        /// <summary> Gets a collection of AlertProcessingRuleResources in the ResourceGroupResource. </summary>
        /// <returns> An object representing collection of AlertProcessingRuleResources and their operations over a AlertProcessingRuleResource. </returns>
        public virtual AlertProcessingRuleCollection GetAlertProcessingRules()
        {
            return GetCachedClient(client => new AlertProcessingRuleCollection(client, Id));
        }

        /// <summary>
        /// Get an alert processing rule by name.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.AlertsManagement/actionRules/{alertProcessingRuleName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>AlertProcessingRules_GetByName</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2021-08-08</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="AlertProcessingRuleResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="alertProcessingRuleName"> The name of the alert processing rule that needs to be fetched. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="alertProcessingRuleName"/> is null. </exception>
        /// <exception cref="ArgumentException"> <paramref name="alertProcessingRuleName"/> is an empty string, and was expected to be non-empty. </exception>
        [ForwardsClientCalls]
        public virtual async Task<Response<AlertProcessingRuleResource>> GetAlertProcessingRuleAsync(string alertProcessingRuleName, CancellationToken cancellationToken = default)
        {
            return await GetAlertProcessingRules().GetAsync(alertProcessingRuleName, cancellationToken).ConfigureAwait(false);
        }

        /// <summary>
        /// Get an alert processing rule by name.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.AlertsManagement/actionRules/{alertProcessingRuleName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>AlertProcessingRules_GetByName</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2021-08-08</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="AlertProcessingRuleResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="alertProcessingRuleName"> The name of the alert processing rule that needs to be fetched. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="alertProcessingRuleName"/> is null. </exception>
        /// <exception cref="ArgumentException"> <paramref name="alertProcessingRuleName"/> is an empty string, and was expected to be non-empty. </exception>
        [ForwardsClientCalls]
        public virtual Response<AlertProcessingRuleResource> GetAlertProcessingRule(string alertProcessingRuleName, CancellationToken cancellationToken = default)
        {
            return GetAlertProcessingRules().Get(alertProcessingRuleName, cancellationToken);
        }
    }
}
