// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using Azure.Core;

namespace Azure.ResourceManager.AlertsManagement.Mocking
{
    /// <summary> A class to add extension methods to ArmClient. </summary>
    public partial class MockableAlertsManagementArmClient : ArmResource
    {
        /// <summary> Initializes a new instance of the <see cref="MockableAlertsManagementArmClient"/> class for mocking. </summary>
        protected MockableAlertsManagementArmClient()
        {
        }

        /// <summary> Initializes a new instance of the <see cref="MockableAlertsManagementArmClient"/> class. </summary>
        /// <param name="client"> The client parameters to use in these operations. </param>
        /// <param name="id"> The identifier of the resource that is the target of operations. </param>
        internal MockableAlertsManagementArmClient(ArmClient client, ResourceIdentifier id) : base(client, id)
        {
        }

        internal MockableAlertsManagementArmClient(ArmClient client) : this(client, ResourceIdentifier.Root)
        {
        }

        private string GetApiVersionOrNull(ResourceType resourceType)
        {
            TryGetApiVersion(resourceType, out string apiVersion);
            return apiVersion;
        }

        /// <summary>
        /// Gets an object representing an <see cref="AlertProcessingRuleResource"/> along with the instance operations that can be performed on it but with no data.
        /// You can use <see cref="AlertProcessingRuleResource.CreateResourceIdentifier" /> to create an <see cref="AlertProcessingRuleResource"/> <see cref="ResourceIdentifier"/> from its components.
        /// </summary>
        /// <param name="id"> The resource ID of the resource to get. </param>
        /// <returns> Returns a <see cref="AlertProcessingRuleResource"/> object. </returns>
        public virtual AlertProcessingRuleResource GetAlertProcessingRuleResource(ResourceIdentifier id)
        {
            AlertProcessingRuleResource.ValidateResourceId(id);
            return new AlertProcessingRuleResource(Client, id);
        }

        /// <summary>
        /// Gets an object representing a <see cref="ServiceAlertResource"/> along with the instance operations that can be performed on it but with no data.
        /// You can use <see cref="ServiceAlertResource.CreateResourceIdentifier" /> to create a <see cref="ServiceAlertResource"/> <see cref="ResourceIdentifier"/> from its components.
        /// </summary>
        /// <param name="id"> The resource ID of the resource to get. </param>
        /// <returns> Returns a <see cref="ServiceAlertResource"/> object. </returns>
        public virtual ServiceAlertResource GetServiceAlertResource(ResourceIdentifier id)
        {
            ServiceAlertResource.ValidateResourceId(id);
            return new ServiceAlertResource(Client, id);
        }

        /// <summary>
        /// Gets an object representing a <see cref="SmartGroupResource"/> along with the instance operations that can be performed on it but with no data.
        /// You can use <see cref="SmartGroupResource.CreateResourceIdentifier" /> to create a <see cref="SmartGroupResource"/> <see cref="ResourceIdentifier"/> from its components.
        /// </summary>
        /// <param name="id"> The resource ID of the resource to get. </param>
        /// <returns> Returns a <see cref="SmartGroupResource"/> object. </returns>
        public virtual SmartGroupResource GetSmartGroupResource(ResourceIdentifier id)
        {
            SmartGroupResource.ValidateResourceId(id);
            return new SmartGroupResource(Client, id);
        }
    }
}
