// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Threading.Tasks;
using Azure.Core;
using Azure.Identity;
using Azure.ResourceManager.AlertsManagement.Models;

namespace Azure.ResourceManager.AlertsManagement.Samples
{
    public partial class Sample_SmartGroupResource
    {
        // Get
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Get_Get()
        {
            // Generated from example definition: specification/alertsmanagement/resource-manager/Microsoft.AlertsManagement/preview/2019-05-05-preview/examples/SmartGroups_GetById.json
            // this example is just showing the usage of "SmartGroups_GetById" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this SmartGroupResource created on azure
            // for more information of creating SmartGroupResource, please refer to the document of SmartGroupResource
            string subscriptionId = "9e261de7-c804-4b9d-9ebf-6f50fe350a9a";
            Guid smartGroupId = Guid.Parse("603675da-9851-4b26-854a-49fc53d32715");
            ResourceIdentifier smartGroupResourceId = SmartGroupResource.CreateResourceIdentifier(subscriptionId, smartGroupId);
            SmartGroupResource smartGroup = client.GetSmartGroupResource(smartGroupResourceId);

            // invoke the operation
            SmartGroupResource result = await smartGroup.GetAsync();

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            SmartGroupData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // changestate
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task ChangeState_Changestate()
        {
            // Generated from example definition: specification/alertsmanagement/resource-manager/Microsoft.AlertsManagement/preview/2019-05-05-preview/examples/SmartGroups_ChangeState.json
            // this example is just showing the usage of "SmartGroups_ChangeState" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this SmartGroupResource created on azure
            // for more information of creating SmartGroupResource, please refer to the document of SmartGroupResource
            string subscriptionId = "dd91de05-d791-4ceb-b6dc-988682dc7d72";
            Guid smartGroupId = Guid.Parse("a808445e-bb38-4751-85c2-1b109ccc1059");
            ResourceIdentifier smartGroupResourceId = SmartGroupResource.CreateResourceIdentifier(subscriptionId, smartGroupId);
            SmartGroupResource smartGroup = client.GetSmartGroupResource(smartGroupResourceId);

            // invoke the operation
            ServiceAlertState newState = ServiceAlertState.Acknowledged;
            SmartGroupResource result = await smartGroup.ChangeStateAsync(newState);

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            SmartGroupData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // Resolve
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task GetHistory_Resolve()
        {
            // Generated from example definition: specification/alertsmanagement/resource-manager/Microsoft.AlertsManagement/preview/2019-05-05-preview/examples/SmartGroups_History.json
            // this example is just showing the usage of "SmartGroups_GetHistory" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this SmartGroupResource created on azure
            // for more information of creating SmartGroupResource, please refer to the document of SmartGroupResource
            string subscriptionId = "9e261de7-c804-4b9d-9ebf-6f50fe350a9a";
            Guid smartGroupId = Guid.Parse("a808445e-bb38-4751-85c2-1b109ccc1059");
            ResourceIdentifier smartGroupResourceId = SmartGroupResource.CreateResourceIdentifier(subscriptionId, smartGroupId);
            SmartGroupResource smartGroup = client.GetSmartGroupResource(smartGroupResourceId);

            // invoke the operation
            SmartGroupModification result = await smartGroup.GetHistoryAsync();

            Console.WriteLine($"Succeeded: {result}");
        }
    }
}
