// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Threading.Tasks;
using Azure.Core;
using Azure.Identity;
using Azure.ResourceManager.AlertsManagement.Models;
using Azure.ResourceManager.Resources;

namespace Azure.ResourceManager.AlertsManagement.Samples
{
    public partial class Sample_ServiceAlertResource
    {
        // MonService
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task GetServiceAlertMetadata_MonService()
        {
            // Generated from example definition: specification/alertsmanagement/resource-manager/Microsoft.AlertsManagement/preview/2019-05-05-preview/examples/AlertsMetaData_MonitorService.json
            // this example is just showing the usage of "Alerts_MetaData" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this TenantResource created on azure
            // for more information of creating TenantResource, please refer to the document of TenantResource
            var tenantResource = client.GetTenants().GetAllAsync().GetAsyncEnumerator().Current;

            // invoke the operation
            RetrievedInformationIdentifier identifier = RetrievedInformationIdentifier.MonitorServiceList;
            ServiceAlertMetadata result = await tenantResource.GetServiceAlertMetadataAsync(identifier);

            Console.WriteLine($"Succeeded: {result}");
        }

        // GetById
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Get_GetById()
        {
            // Generated from example definition: specification/alertsmanagement/resource-manager/Microsoft.AlertsManagement/preview/2019-05-05-preview/examples/Alerts_GetById.json
            // this example is just showing the usage of "Alerts_GetById" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this ServiceAlertResource created on azure
            // for more information of creating ServiceAlertResource, please refer to the document of ServiceAlertResource
            string subscriptionId = "9e261de7-c804-4b9d-9ebf-6f50fe350a9a";
            Guid alertId = Guid.Parse("66114d64-d9d9-478b-95c9-b789d6502100");
            ResourceIdentifier serviceAlertResourceId = ServiceAlertResource.CreateResourceIdentifier(subscriptionId, alertId);
            ServiceAlertResource serviceAlert = client.GetServiceAlertResource(serviceAlertResourceId);

            // invoke the operation
            ServiceAlertResource result = await serviceAlert.GetAsync();

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            ServiceAlertData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // Resolve
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task ChangeState_Resolve()
        {
            // Generated from example definition: specification/alertsmanagement/resource-manager/Microsoft.AlertsManagement/preview/2019-05-05-preview/examples/Alerts_ChangeState.json
            // this example is just showing the usage of "Alerts_ChangeState" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this ServiceAlertResource created on azure
            // for more information of creating ServiceAlertResource, please refer to the document of ServiceAlertResource
            string subscriptionId = "9e261de7-c804-4b9d-9ebf-6f50fe350a9a";
            Guid alertId = Guid.Parse("66114d64-d9d9-478b-95c9-b789d6502100");
            ResourceIdentifier serviceAlertResourceId = ServiceAlertResource.CreateResourceIdentifier(subscriptionId, alertId);
            ServiceAlertResource serviceAlert = client.GetServiceAlertResource(serviceAlertResourceId);

            // invoke the operation
            ServiceAlertState newState = ServiceAlertState.Acknowledged;
            ServiceAlertResource result = await serviceAlert.ChangeStateAsync(newState);

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            ServiceAlertData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // Resolve
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task GetHistory_Resolve()
        {
            // Generated from example definition: specification/alertsmanagement/resource-manager/Microsoft.AlertsManagement/preview/2019-05-05-preview/examples/Alerts_History.json
            // this example is just showing the usage of "Alerts_GetHistory" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this ServiceAlertResource created on azure
            // for more information of creating ServiceAlertResource, please refer to the document of ServiceAlertResource
            string subscriptionId = "9e261de7-c804-4b9d-9ebf-6f50fe350a9a";
            Guid alertId = Guid.Parse("66114d64-d9d9-478b-95c9-b789d6502100");
            ResourceIdentifier serviceAlertResourceId = ServiceAlertResource.CreateResourceIdentifier(subscriptionId, alertId);
            ServiceAlertResource serviceAlert = client.GetServiceAlertResource(serviceAlertResourceId);

            // invoke the operation
            ServiceAlertModification result = await serviceAlert.GetHistoryAsync();

            Console.WriteLine($"Succeeded: {result}");
        }

        // Summary
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task GetServiceAlertSummary_Summary()
        {
            // Generated from example definition: specification/alertsmanagement/resource-manager/Microsoft.AlertsManagement/preview/2019-05-05-preview/examples/Alerts_Summary.json
            // this example is just showing the usage of "Alerts_GetSummary" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this SubscriptionResource created on azure
            // for more information of creating SubscriptionResource, please refer to the document of SubscriptionResource
            string subscriptionId = "1e3ff1c0-771a-4119-a03b-be82a51e232d";
            ResourceIdentifier subscriptionResourceId = SubscriptionResource.CreateResourceIdentifier(subscriptionId);
            SubscriptionResource subscriptionResource = client.GetSubscriptionResource(subscriptionResourceId);

            // invoke the operation
            SubscriptionResourceGetServiceAlertSummaryOptions options = new SubscriptionResourceGetServiceAlertSummaryOptions(groupby: new AlertsSummaryGroupByField("severity,alertState")) { };
            ServiceAlertSummary result = await subscriptionResource.GetServiceAlertSummaryAsync(options);

            Console.WriteLine($"Succeeded: {result}");
        }
    }
}
