// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Threading.Tasks;
using Azure.Core;
using Azure.Identity;
using Azure.ResourceManager.AlertsManagement.Models;
using Azure.ResourceManager.Resources;

namespace Azure.ResourceManager.AlertsManagement.Samples
{
    public partial class Sample_AlertProcessingRuleCollection
    {
        // GetAlertProcessingRulesResourceGroupWide
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task GetAll_GetAlertProcessingRulesResourceGroupWide()
        {
            // Generated from example definition: specification/alertsmanagement/resource-manager/Microsoft.AlertsManagement/stable/2021-08-08/examples/AlertProcessingRules_List_ResourceGroup.json
            // this example is just showing the usage of "AlertProcessingRules_ListByResourceGroup" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this ResourceGroupResource created on azure
            // for more information of creating ResourceGroupResource, please refer to the document of ResourceGroupResource
            string subscriptionId = "1e3ff1c0-771a-4119-a03b-be82a51e232d";
            string resourceGroupName = "alertscorrelationrg";
            ResourceIdentifier resourceGroupResourceId = ResourceGroupResource.CreateResourceIdentifier(subscriptionId, resourceGroupName);
            ResourceGroupResource resourceGroupResource = client.GetResourceGroupResource(resourceGroupResourceId);

            // get the collection of this AlertProcessingRuleResource
            AlertProcessingRuleCollection collection = resourceGroupResource.GetAlertProcessingRules();

            // invoke the operation and iterate over the result
            await foreach (AlertProcessingRuleResource item in collection.GetAllAsync())
            {
                // the variable item is a resource, you could call other operations on this instance as well
                // but just for demo, we get its data from this resource instance
                AlertProcessingRuleData resourceData = item.Data;
                // for demo we just print out the id
                Console.WriteLine($"Succeeded on id: {resourceData.Id}");
            }

            Console.WriteLine($"Succeeded");
        }

        // GetAlertProcessingRuleById
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Get_GetAlertProcessingRuleById()
        {
            // Generated from example definition: specification/alertsmanagement/resource-manager/Microsoft.AlertsManagement/stable/2021-08-08/examples/AlertProcessingRules_GetById.json
            // this example is just showing the usage of "AlertProcessingRules_GetByName" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this ResourceGroupResource created on azure
            // for more information of creating ResourceGroupResource, please refer to the document of ResourceGroupResource
            string subscriptionId = "1e3ff1c0-771a-4119-a03b-be82a51e232d";
            string resourceGroupName = "alertscorrelationrg";
            ResourceIdentifier resourceGroupResourceId = ResourceGroupResource.CreateResourceIdentifier(subscriptionId, resourceGroupName);
            ResourceGroupResource resourceGroupResource = client.GetResourceGroupResource(resourceGroupResourceId);

            // get the collection of this AlertProcessingRuleResource
            AlertProcessingRuleCollection collection = resourceGroupResource.GetAlertProcessingRules();

            // invoke the operation
            string alertProcessingRuleName = "DailySuppression";
            AlertProcessingRuleResource result = await collection.GetAsync(alertProcessingRuleName);

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            AlertProcessingRuleData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // GetAlertProcessingRuleById
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Exists_GetAlertProcessingRuleById()
        {
            // Generated from example definition: specification/alertsmanagement/resource-manager/Microsoft.AlertsManagement/stable/2021-08-08/examples/AlertProcessingRules_GetById.json
            // this example is just showing the usage of "AlertProcessingRules_GetByName" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this ResourceGroupResource created on azure
            // for more information of creating ResourceGroupResource, please refer to the document of ResourceGroupResource
            string subscriptionId = "1e3ff1c0-771a-4119-a03b-be82a51e232d";
            string resourceGroupName = "alertscorrelationrg";
            ResourceIdentifier resourceGroupResourceId = ResourceGroupResource.CreateResourceIdentifier(subscriptionId, resourceGroupName);
            ResourceGroupResource resourceGroupResource = client.GetResourceGroupResource(resourceGroupResourceId);

            // get the collection of this AlertProcessingRuleResource
            AlertProcessingRuleCollection collection = resourceGroupResource.GetAlertProcessingRules();

            // invoke the operation
            string alertProcessingRuleName = "DailySuppression";
            bool result = await collection.ExistsAsync(alertProcessingRuleName);

            Console.WriteLine($"Succeeded: {result}");
        }

        // GetAlertProcessingRuleById
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task GetIfExists_GetAlertProcessingRuleById()
        {
            // Generated from example definition: specification/alertsmanagement/resource-manager/Microsoft.AlertsManagement/stable/2021-08-08/examples/AlertProcessingRules_GetById.json
            // this example is just showing the usage of "AlertProcessingRules_GetByName" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this ResourceGroupResource created on azure
            // for more information of creating ResourceGroupResource, please refer to the document of ResourceGroupResource
            string subscriptionId = "1e3ff1c0-771a-4119-a03b-be82a51e232d";
            string resourceGroupName = "alertscorrelationrg";
            ResourceIdentifier resourceGroupResourceId = ResourceGroupResource.CreateResourceIdentifier(subscriptionId, resourceGroupName);
            ResourceGroupResource resourceGroupResource = client.GetResourceGroupResource(resourceGroupResourceId);

            // get the collection of this AlertProcessingRuleResource
            AlertProcessingRuleCollection collection = resourceGroupResource.GetAlertProcessingRules();

            // invoke the operation
            string alertProcessingRuleName = "DailySuppression";
            NullableResponse<AlertProcessingRuleResource> response = await collection.GetIfExistsAsync(alertProcessingRuleName);
            AlertProcessingRuleResource result = response.HasValue ? response.Value : null;

            if (result == null)
            {
                Console.WriteLine($"Succeeded with null as result");
            }
            else
            {
                // the variable result is a resource, you could call other operations on this instance as well
                // but just for demo, we get its data from this resource instance
                AlertProcessingRuleData resourceData = result.Data;
                // for demo we just print out the id
                Console.WriteLine($"Succeeded on id: {resourceData.Id}");
            }
        }

        // Create or update a rule that adds an action group to all alerts in a subscription
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task CreateOrUpdate_CreateOrUpdateARuleThatAddsAnActionGroupToAllAlertsInASubscription()
        {
            // Generated from example definition: specification/alertsmanagement/resource-manager/Microsoft.AlertsManagement/stable/2021-08-08/examples/AlertProcessingRules_Create_or_update_add_action_group_all_alerts_in_subscription.json
            // this example is just showing the usage of "AlertProcessingRules_CreateOrUpdate" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this ResourceGroupResource created on azure
            // for more information of creating ResourceGroupResource, please refer to the document of ResourceGroupResource
            string subscriptionId = "subId1";
            string resourceGroupName = "alertscorrelationrg";
            ResourceIdentifier resourceGroupResourceId = ResourceGroupResource.CreateResourceIdentifier(subscriptionId, resourceGroupName);
            ResourceGroupResource resourceGroupResource = client.GetResourceGroupResource(resourceGroupResourceId);

            // get the collection of this AlertProcessingRuleResource
            AlertProcessingRuleCollection collection = resourceGroupResource.GetAlertProcessingRules();

            // invoke the operation
            string alertProcessingRuleName = "AddActionGroupToSubscription";
            AlertProcessingRuleData data = new AlertProcessingRuleData(new AzureLocation("Global"))
            {
                Properties = new AlertProcessingRuleProperties(new string[]
            {
"/subscriptions/subId1"
            }, new AlertProcessingRuleAction[]
            {
new AlertProcessingRuleAddGroupsAction(new ResourceIdentifier[]
{
new ResourceIdentifier("/subscriptions/subId1/resourcegroups/RGId1/providers/microsoft.insights/actiongroups/ActionGroup1")
})
            })
                {
                    Description = "Add ActionGroup1 to all alerts in the subscription",
                    IsEnabled = true,
                },
                Tags =
{
},
            };
            ArmOperation<AlertProcessingRuleResource> lro = await collection.CreateOrUpdateAsync(WaitUntil.Completed, alertProcessingRuleName, data);
            AlertProcessingRuleResource result = lro.Value;

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            AlertProcessingRuleData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // Create or update a rule that adds two action groups to all Sev0 and Sev1 alerts in two resource groups
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task CreateOrUpdate_CreateOrUpdateARuleThatAddsTwoActionGroupsToAllSev0AndSev1AlertsInTwoResourceGroups()
        {
            // Generated from example definition: specification/alertsmanagement/resource-manager/Microsoft.AlertsManagement/stable/2021-08-08/examples/AlertProcessingRules_Create_or_update_add_two_action_groups_all_Sev0_Sev1_two_resource_groups.json
            // this example is just showing the usage of "AlertProcessingRules_CreateOrUpdate" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this ResourceGroupResource created on azure
            // for more information of creating ResourceGroupResource, please refer to the document of ResourceGroupResource
            string subscriptionId = "subId1";
            string resourceGroupName = "alertscorrelationrg";
            ResourceIdentifier resourceGroupResourceId = ResourceGroupResource.CreateResourceIdentifier(subscriptionId, resourceGroupName);
            ResourceGroupResource resourceGroupResource = client.GetResourceGroupResource(resourceGroupResourceId);

            // get the collection of this AlertProcessingRuleResource
            AlertProcessingRuleCollection collection = resourceGroupResource.GetAlertProcessingRules();

            // invoke the operation
            string alertProcessingRuleName = "AddActionGroupsBySeverity";
            AlertProcessingRuleData data = new AlertProcessingRuleData(new AzureLocation("Global"))
            {
                Properties = new AlertProcessingRuleProperties(new string[]
            {
"/subscriptions/subId1/resourceGroups/RGId1","/subscriptions/subId1/resourceGroups/RGId2"
            }, new AlertProcessingRuleAction[]
            {
new AlertProcessingRuleAddGroupsAction(new ResourceIdentifier[]
{
new ResourceIdentifier("/subscriptions/subId1/resourcegroups/RGId1/providers/microsoft.insights/actiongroups/AGId1"),new ResourceIdentifier("/subscriptions/subId1/resourcegroups/RGId1/providers/microsoft.insights/actiongroups/AGId2")
})
            })
                {
                    Conditions =
{
new AlertProcessingRuleCondition()
{
Field = AlertProcessingRuleField.Severity,
Operator = AlertProcessingRuleOperator.EqualsValue,
Values =
{
"sev0","sev1"
},
}
},
                    Description = "Add AGId1 and AGId2 to all Sev0 and Sev1 alerts in these resourceGroups",
                    IsEnabled = true,
                },
                Tags =
{
},
            };
            ArmOperation<AlertProcessingRuleResource> lro = await collection.CreateOrUpdateAsync(WaitUntil.Completed, alertProcessingRuleName, data);
            AlertProcessingRuleResource result = lro.Value;

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            AlertProcessingRuleData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // Create or update a rule that removes all action groups from alerts on a specific VM during a one-off maintenance window (1800-2000 at a specific date, Pacific Standard Time)
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task CreateOrUpdate_CreateOrUpdateARuleThatRemovesAllActionGroupsFromAlertsOnASpecificVMDuringAOneOffMaintenanceWindow18002000AtASpecificDatePacificStandardTime()
        {
            // Generated from example definition: specification/alertsmanagement/resource-manager/Microsoft.AlertsManagement/stable/2021-08-08/examples/AlertProcessingRules_Create_or_update_remove_all_action_groups_specific_VM_one-off_maintenance_window.json
            // this example is just showing the usage of "AlertProcessingRules_CreateOrUpdate" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this ResourceGroupResource created on azure
            // for more information of creating ResourceGroupResource, please refer to the document of ResourceGroupResource
            string subscriptionId = "subId1";
            string resourceGroupName = "alertscorrelationrg";
            ResourceIdentifier resourceGroupResourceId = ResourceGroupResource.CreateResourceIdentifier(subscriptionId, resourceGroupName);
            ResourceGroupResource resourceGroupResource = client.GetResourceGroupResource(resourceGroupResourceId);

            // get the collection of this AlertProcessingRuleResource
            AlertProcessingRuleCollection collection = resourceGroupResource.GetAlertProcessingRules();

            // invoke the operation
            string alertProcessingRuleName = "RemoveActionGroupsMaintenanceWindow";
            AlertProcessingRuleData data = new AlertProcessingRuleData(new AzureLocation("Global"))
            {
                Properties = new AlertProcessingRuleProperties(new string[]
            {
"/subscriptions/subId1/resourceGroups/RGId1/providers/Microsoft.Compute/virtualMachines/VMName"
            }, new AlertProcessingRuleAction[]
            {
new AlertProcessingRuleRemoveAllGroupsAction()
            })
                {
                    Schedule = new AlertProcessingRuleSchedule()
                    {
                        EffectiveFrom = DateTimeOffset.Parse("2021-04-15T18:00:00"),
                        EffectiveUntil = DateTimeOffset.Parse("2021-04-15T20:00:00"),
                        TimeZone = "Pacific Standard Time",
                    },
                    Description = "Removes all ActionGroups from all Alerts on VMName during the maintenance window",
                    IsEnabled = true,
                },
                Tags =
{
},
            };
            ArmOperation<AlertProcessingRuleResource> lro = await collection.CreateOrUpdateAsync(WaitUntil.Completed, alertProcessingRuleName, data);
            AlertProcessingRuleResource result = lro.Value;

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            AlertProcessingRuleData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // Create or update a rule that removes all action groups from all alerts in a subscription coming from a specific alert rule
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task CreateOrUpdate_CreateOrUpdateARuleThatRemovesAllActionGroupsFromAllAlertsInASubscriptionComingFromASpecificAlertRule()
        {
            // Generated from example definition: specification/alertsmanagement/resource-manager/Microsoft.AlertsManagement/stable/2021-08-08/examples/AlertProcessingRules_Create_or_update_remove_all_action_groups_from_specific_alert_rule.json
            // this example is just showing the usage of "AlertProcessingRules_CreateOrUpdate" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this ResourceGroupResource created on azure
            // for more information of creating ResourceGroupResource, please refer to the document of ResourceGroupResource
            string subscriptionId = "subId1";
            string resourceGroupName = "alertscorrelationrg";
            ResourceIdentifier resourceGroupResourceId = ResourceGroupResource.CreateResourceIdentifier(subscriptionId, resourceGroupName);
            ResourceGroupResource resourceGroupResource = client.GetResourceGroupResource(resourceGroupResourceId);

            // get the collection of this AlertProcessingRuleResource
            AlertProcessingRuleCollection collection = resourceGroupResource.GetAlertProcessingRules();

            // invoke the operation
            string alertProcessingRuleName = "RemoveActionGroupsSpecificAlertRule";
            AlertProcessingRuleData data = new AlertProcessingRuleData(new AzureLocation("Global"))
            {
                Properties = new AlertProcessingRuleProperties(new string[]
            {
"/subscriptions/subId1"
            }, new AlertProcessingRuleAction[]
            {
new AlertProcessingRuleRemoveAllGroupsAction()
            })
                {
                    Conditions =
{
new AlertProcessingRuleCondition()
{
Field = AlertProcessingRuleField.AlertRuleId,
Operator = AlertProcessingRuleOperator.EqualsValue,
Values =
{
"/subscriptions/suubId1/resourceGroups/Rgid2/providers/microsoft.insights/activityLogAlerts/RuleName"
},
}
},
                    Description = "Removes all ActionGroups from all Alerts that fire on above AlertRule",
                    IsEnabled = true,
                },
                Tags =
{
},
            };
            ArmOperation<AlertProcessingRuleResource> lro = await collection.CreateOrUpdateAsync(WaitUntil.Completed, alertProcessingRuleName, data);
            AlertProcessingRuleResource result = lro.Value;

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            AlertProcessingRuleData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // Create or update a rule that removes all action groups from all alerts on any VM in two resource groups during a recurring maintenance window (2200-0400 every Sat and Sun, India Standard Time)
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task CreateOrUpdate_CreateOrUpdateARuleThatRemovesAllActionGroupsFromAllAlertsOnAnyVMInTwoResourceGroupsDuringARecurringMaintenanceWindow22000400EverySatAndSunIndiaStandardTime()
        {
            // Generated from example definition: specification/alertsmanagement/resource-manager/Microsoft.AlertsManagement/stable/2021-08-08/examples/AlertProcessingRules_Create_or_update_remove_all_action_groups_recurring_maintenance_window.json
            // this example is just showing the usage of "AlertProcessingRules_CreateOrUpdate" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this ResourceGroupResource created on azure
            // for more information of creating ResourceGroupResource, please refer to the document of ResourceGroupResource
            string subscriptionId = "subId1";
            string resourceGroupName = "alertscorrelationrg";
            ResourceIdentifier resourceGroupResourceId = ResourceGroupResource.CreateResourceIdentifier(subscriptionId, resourceGroupName);
            ResourceGroupResource resourceGroupResource = client.GetResourceGroupResource(resourceGroupResourceId);

            // get the collection of this AlertProcessingRuleResource
            AlertProcessingRuleCollection collection = resourceGroupResource.GetAlertProcessingRules();

            // invoke the operation
            string alertProcessingRuleName = "RemoveActionGroupsRecurringMaintenance";
            AlertProcessingRuleData data = new AlertProcessingRuleData(new AzureLocation("Global"))
            {
                Properties = new AlertProcessingRuleProperties(new string[]
            {
"/subscriptions/subId1/resourceGroups/RGId1","/subscriptions/subId1/resourceGroups/RGId2"
            }, new AlertProcessingRuleAction[]
            {
new AlertProcessingRuleRemoveAllGroupsAction()
            })
                {
                    Conditions =
{
new AlertProcessingRuleCondition()
{
Field = AlertProcessingRuleField.TargetResourceType,
Operator = AlertProcessingRuleOperator.EqualsValue,
Values =
{
"microsoft.compute/virtualmachines"
},
}
},
                    Schedule = new AlertProcessingRuleSchedule()
                    {
                        TimeZone = "India Standard Time",
                        Recurrences =
{
new AlertProcessingRuleWeeklyRecurrence(new AlertsManagementDayOfWeek[]
{
AlertsManagementDayOfWeek.Saturday,AlertsManagementDayOfWeek.Sunday
})
{
StartOn = TimeSpan.Parse("22:00:00"),
EndOn = TimeSpan.Parse("04:00:00"),
}
},
                    },
                    Description = "Remove all ActionGroups from all Vitual machine Alerts during the recurring maintenance",
                    IsEnabled = true,
                },
                Tags =
{
},
            };
            ArmOperation<AlertProcessingRuleResource> lro = await collection.CreateOrUpdateAsync(WaitUntil.Completed, alertProcessingRuleName, data);
            AlertProcessingRuleResource result = lro.Value;

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            AlertProcessingRuleData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // Create or update a rule that removes all action groups outside business hours (Mon-Fri 09:00-17:00, Eastern Standard Time)
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task CreateOrUpdate_CreateOrUpdateARuleThatRemovesAllActionGroupsOutsideBusinessHoursMonFri09001700EasternStandardTime()
        {
            // Generated from example definition: specification/alertsmanagement/resource-manager/Microsoft.AlertsManagement/stable/2021-08-08/examples/AlertProcessingRules_Create_or_update_remove_all_action_groups_outside_business_hours.json
            // this example is just showing the usage of "AlertProcessingRules_CreateOrUpdate" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this ResourceGroupResource created on azure
            // for more information of creating ResourceGroupResource, please refer to the document of ResourceGroupResource
            string subscriptionId = "subId1";
            string resourceGroupName = "alertscorrelationrg";
            ResourceIdentifier resourceGroupResourceId = ResourceGroupResource.CreateResourceIdentifier(subscriptionId, resourceGroupName);
            ResourceGroupResource resourceGroupResource = client.GetResourceGroupResource(resourceGroupResourceId);

            // get the collection of this AlertProcessingRuleResource
            AlertProcessingRuleCollection collection = resourceGroupResource.GetAlertProcessingRules();

            // invoke the operation
            string alertProcessingRuleName = "RemoveActionGroupsOutsideBusinessHours";
            AlertProcessingRuleData data = new AlertProcessingRuleData(new AzureLocation("Global"))
            {
                Properties = new AlertProcessingRuleProperties(new string[]
            {
"/subscriptions/subId1"
            }, new AlertProcessingRuleAction[]
            {
new AlertProcessingRuleRemoveAllGroupsAction()
            })
                {
                    Schedule = new AlertProcessingRuleSchedule()
                    {
                        TimeZone = "Eastern Standard Time",
                        Recurrences =
{
new DailyRecurrence()
{
StartOn = TimeSpan.Parse("17:00:00"),
EndOn = TimeSpan.Parse("09:00:00"),
},new AlertProcessingRuleWeeklyRecurrence(new AlertsManagementDayOfWeek[]
{
AlertsManagementDayOfWeek.Saturday,AlertsManagementDayOfWeek.Sunday
})
},
                    },
                    Description = "Remove all ActionGroups outside business hours",
                    IsEnabled = true,
                },
                Tags =
{
},
            };
            ArmOperation<AlertProcessingRuleResource> lro = await collection.CreateOrUpdateAsync(WaitUntil.Completed, alertProcessingRuleName, data);
            AlertProcessingRuleResource result = lro.Value;

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            AlertProcessingRuleData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }
    }
}
