// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Text.Json;
using System.Threading.Tasks;
using Azure.Core;
using Azure.Identity;
using NUnit.Framework;

namespace Azure.AI.Inference.Samples
{
    public partial class Samples_EmbeddingsClient
    {
        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_Client2_Embed_MaximumSetEmbeddings()
        {
            Uri endpoint = new Uri("<endpoint>");
            AzureKeyCredential credential = new AzureKeyCredential("<key>");
            EmbeddingsClient client = new EmbeddingsClient(endpoint, credential);

            using RequestContent content = RequestContent.Create(new object());
            Response response = client.Embed(content);

            JsonElement result = JsonDocument.Parse(response.ContentStream).RootElement;
            Console.WriteLine(result.GetProperty("id").ToString());
            Console.WriteLine(result.GetProperty("data")[0].GetProperty("embedding").ToString());
            Console.WriteLine(result.GetProperty("data")[0].GetProperty("index").ToString());
            Console.WriteLine(result.GetProperty("usage").GetProperty("prompt_tokens").ToString());
            Console.WriteLine(result.GetProperty("usage").GetProperty("total_tokens").ToString());
            Console.WriteLine(result.GetProperty("model").ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_Client2_Embed_MaximumSetEmbeddings_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            AzureKeyCredential credential = new AzureKeyCredential("<key>");
            EmbeddingsClient client = new EmbeddingsClient(endpoint, credential);

            using RequestContent content = RequestContent.Create(new object());
            Response response = await client.EmbedAsync(content);

            JsonElement result = JsonDocument.Parse(response.ContentStream).RootElement;
            Console.WriteLine(result.GetProperty("id").ToString());
            Console.WriteLine(result.GetProperty("data")[0].GetProperty("embedding").ToString());
            Console.WriteLine(result.GetProperty("data")[0].GetProperty("index").ToString());
            Console.WriteLine(result.GetProperty("usage").GetProperty("prompt_tokens").ToString());
            Console.WriteLine(result.GetProperty("usage").GetProperty("total_tokens").ToString());
            Console.WriteLine(result.GetProperty("model").ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_Client2_Embed_MaximumSetEmbeddings_Convenience()
        {
            Uri endpoint = new Uri("<endpoint>");
            AzureKeyCredential credential = new AzureKeyCredential("<key>");
            EmbeddingsClient client = new EmbeddingsClient(endpoint, credential);

            EmbeddingsOptions embeddingsOptions = null;
            Response<EmbeddingsResult> response = client.Embed(embeddingsOptions);
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_Client2_Embed_MaximumSetEmbeddings_Convenience_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            AzureKeyCredential credential = new AzureKeyCredential("<key>");
            EmbeddingsClient client = new EmbeddingsClient(endpoint, credential);

            EmbeddingsOptions embeddingsOptions = null;
            Response<EmbeddingsResult> response = await client.EmbedAsync(embeddingsOptions);
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_Client2_Embed_MinimumSetEmbeddings()
        {
            Uri endpoint = new Uri("<endpoint>");
            AzureKeyCredential credential = new AzureKeyCredential("<key>");
            EmbeddingsClient client = new EmbeddingsClient(endpoint, credential);

            using RequestContent content = RequestContent.Create(new object());
            Response response = client.Embed(content);

            JsonElement result = JsonDocument.Parse(response.ContentStream).RootElement;
            Console.WriteLine(result.GetProperty("id").ToString());
            Console.WriteLine(result.GetProperty("data")[0].GetProperty("embedding").ToString());
            Console.WriteLine(result.GetProperty("data")[0].GetProperty("index").ToString());
            Console.WriteLine(result.GetProperty("usage").GetProperty("prompt_tokens").ToString());
            Console.WriteLine(result.GetProperty("usage").GetProperty("total_tokens").ToString());
            Console.WriteLine(result.GetProperty("model").ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_Client2_Embed_MinimumSetEmbeddings_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            AzureKeyCredential credential = new AzureKeyCredential("<key>");
            EmbeddingsClient client = new EmbeddingsClient(endpoint, credential);

            using RequestContent content = RequestContent.Create(new object());
            Response response = await client.EmbedAsync(content);

            JsonElement result = JsonDocument.Parse(response.ContentStream).RootElement;
            Console.WriteLine(result.GetProperty("id").ToString());
            Console.WriteLine(result.GetProperty("data")[0].GetProperty("embedding").ToString());
            Console.WriteLine(result.GetProperty("data")[0].GetProperty("index").ToString());
            Console.WriteLine(result.GetProperty("usage").GetProperty("prompt_tokens").ToString());
            Console.WriteLine(result.GetProperty("usage").GetProperty("total_tokens").ToString());
            Console.WriteLine(result.GetProperty("model").ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_Client2_Embed_MinimumSetEmbeddings_Convenience()
        {
            Uri endpoint = new Uri("<endpoint>");
            AzureKeyCredential credential = new AzureKeyCredential("<key>");
            EmbeddingsClient client = new EmbeddingsClient(endpoint, credential);

            EmbeddingsOptions embeddingsOptions = null;
            Response<EmbeddingsResult> response = client.Embed(embeddingsOptions);
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_Client2_Embed_MinimumSetEmbeddings_Convenience_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            AzureKeyCredential credential = new AzureKeyCredential("<key>");
            EmbeddingsClient client = new EmbeddingsClient(endpoint, credential);

            EmbeddingsOptions embeddingsOptions = null;
            Response<EmbeddingsResult> response = await client.EmbedAsync(embeddingsOptions);
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_Client2_GetModelInfo_MaximumSetModelInformation()
        {
            Uri endpoint = new Uri("<endpoint>");
            AzureKeyCredential credential = new AzureKeyCredential("<key>");
            EmbeddingsClient client = new EmbeddingsClient(endpoint, credential);

            Response response = client.GetModelInfo(null);

            JsonElement result = JsonDocument.Parse(response.ContentStream).RootElement;
            Console.WriteLine(result.GetProperty("model_name").ToString());
            Console.WriteLine(result.GetProperty("model_type").ToString());
            Console.WriteLine(result.GetProperty("model_provider_name").ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_Client2_GetModelInfo_MaximumSetModelInformation_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            AzureKeyCredential credential = new AzureKeyCredential("<key>");
            EmbeddingsClient client = new EmbeddingsClient(endpoint, credential);

            Response response = await client.GetModelInfoAsync(null);

            JsonElement result = JsonDocument.Parse(response.ContentStream).RootElement;
            Console.WriteLine(result.GetProperty("model_name").ToString());
            Console.WriteLine(result.GetProperty("model_type").ToString());
            Console.WriteLine(result.GetProperty("model_provider_name").ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_Client2_GetModelInfo_MaximumSetModelInformation_Convenience()
        {
            Uri endpoint = new Uri("<endpoint>");
            AzureKeyCredential credential = new AzureKeyCredential("<key>");
            EmbeddingsClient client = new EmbeddingsClient(endpoint, credential);

            Response<ModelInfo> response = client.GetModelInfo();
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_Client2_GetModelInfo_MaximumSetModelInformation_Convenience_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            AzureKeyCredential credential = new AzureKeyCredential("<key>");
            EmbeddingsClient client = new EmbeddingsClient(endpoint, credential);

            Response<ModelInfo> response = await client.GetModelInfoAsync();
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_Client2_GetModelInfo_MinimumSetModelInformation()
        {
            Uri endpoint = new Uri("<endpoint>");
            AzureKeyCredential credential = new AzureKeyCredential("<key>");
            EmbeddingsClient client = new EmbeddingsClient(endpoint, credential);

            Response response = client.GetModelInfo(null);

            JsonElement result = JsonDocument.Parse(response.ContentStream).RootElement;
            Console.WriteLine(result.GetProperty("model_name").ToString());
            Console.WriteLine(result.GetProperty("model_type").ToString());
            Console.WriteLine(result.GetProperty("model_provider_name").ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_Client2_GetModelInfo_MinimumSetModelInformation_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            AzureKeyCredential credential = new AzureKeyCredential("<key>");
            EmbeddingsClient client = new EmbeddingsClient(endpoint, credential);

            Response response = await client.GetModelInfoAsync(null);

            JsonElement result = JsonDocument.Parse(response.ContentStream).RootElement;
            Console.WriteLine(result.GetProperty("model_name").ToString());
            Console.WriteLine(result.GetProperty("model_type").ToString());
            Console.WriteLine(result.GetProperty("model_provider_name").ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_Client2_GetModelInfo_MinimumSetModelInformation_Convenience()
        {
            Uri endpoint = new Uri("<endpoint>");
            AzureKeyCredential credential = new AzureKeyCredential("<key>");
            EmbeddingsClient client = new EmbeddingsClient(endpoint, credential);

            Response<ModelInfo> response = client.GetModelInfo();
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_Client2_GetModelInfo_MinimumSetModelInformation_Convenience_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            AzureKeyCredential credential = new AzureKeyCredential("<key>");
            EmbeddingsClient client = new EmbeddingsClient(endpoint, credential);

            Response<ModelInfo> response = await client.GetModelInfoAsync();
        }
    }
}
