// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Text.Json;
using System.Threading.Tasks;
using Azure.Identity;
using NUnit.Framework;

namespace Azure.AI.Inference.Samples
{
    public partial class Samples_ChatCompletionsClient
    {
        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_Client1_GetModelInfo_MaximumSetModelInformation()
        {
            Uri endpoint = new Uri("<endpoint>");
            AzureKeyCredential credential = new AzureKeyCredential("<key>");
            ChatCompletionsClient client = new ChatCompletionsClient(endpoint, credential);

            Response response = client.GetModelInfo(null);

            JsonElement result = JsonDocument.Parse(response.ContentStream).RootElement;
            Console.WriteLine(result.GetProperty("model_name").ToString());
            Console.WriteLine(result.GetProperty("model_type").ToString());
            Console.WriteLine(result.GetProperty("model_provider_name").ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_Client1_GetModelInfo_MaximumSetModelInformation_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            AzureKeyCredential credential = new AzureKeyCredential("<key>");
            ChatCompletionsClient client = new ChatCompletionsClient(endpoint, credential);

            Response response = await client.GetModelInfoAsync(null);

            JsonElement result = JsonDocument.Parse(response.ContentStream).RootElement;
            Console.WriteLine(result.GetProperty("model_name").ToString());
            Console.WriteLine(result.GetProperty("model_type").ToString());
            Console.WriteLine(result.GetProperty("model_provider_name").ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_Client1_GetModelInfo_MaximumSetModelInformation_Convenience()
        {
            Uri endpoint = new Uri("<endpoint>");
            AzureKeyCredential credential = new AzureKeyCredential("<key>");
            ChatCompletionsClient client = new ChatCompletionsClient(endpoint, credential);

            Response<ModelInfo> response = client.GetModelInfo();
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_Client1_GetModelInfo_MaximumSetModelInformation_Convenience_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            AzureKeyCredential credential = new AzureKeyCredential("<key>");
            ChatCompletionsClient client = new ChatCompletionsClient(endpoint, credential);

            Response<ModelInfo> response = await client.GetModelInfoAsync();
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_Client1_GetModelInfo_MinimumSetModelInformation()
        {
            Uri endpoint = new Uri("<endpoint>");
            AzureKeyCredential credential = new AzureKeyCredential("<key>");
            ChatCompletionsClient client = new ChatCompletionsClient(endpoint, credential);

            Response response = client.GetModelInfo(null);

            JsonElement result = JsonDocument.Parse(response.ContentStream).RootElement;
            Console.WriteLine(result.GetProperty("model_name").ToString());
            Console.WriteLine(result.GetProperty("model_type").ToString());
            Console.WriteLine(result.GetProperty("model_provider_name").ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_Client1_GetModelInfo_MinimumSetModelInformation_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            AzureKeyCredential credential = new AzureKeyCredential("<key>");
            ChatCompletionsClient client = new ChatCompletionsClient(endpoint, credential);

            Response response = await client.GetModelInfoAsync(null);

            JsonElement result = JsonDocument.Parse(response.ContentStream).RootElement;
            Console.WriteLine(result.GetProperty("model_name").ToString());
            Console.WriteLine(result.GetProperty("model_type").ToString());
            Console.WriteLine(result.GetProperty("model_provider_name").ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_Client1_GetModelInfo_MinimumSetModelInformation_Convenience()
        {
            Uri endpoint = new Uri("<endpoint>");
            AzureKeyCredential credential = new AzureKeyCredential("<key>");
            ChatCompletionsClient client = new ChatCompletionsClient(endpoint, credential);

            Response<ModelInfo> response = client.GetModelInfo();
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_Client1_GetModelInfo_MinimumSetModelInformation_Convenience_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            AzureKeyCredential credential = new AzureKeyCredential("<key>");
            ChatCompletionsClient client = new ChatCompletionsClient(endpoint, credential);

            Response<ModelInfo> response = await client.GetModelInfoAsync();
        }
    }
}
