// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.AI.Inference
{
    /// <summary>
    /// Represents an update to a single prompt completion when the service is streaming updates
    /// using Server Sent Events (SSE).
    /// Generally, `n` choices are generated per provided prompt with a default value of 1.
    /// Token limits and other settings may limit the number of choices generated.
    /// </summary>
    public partial class StreamingChatChoiceUpdate
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="StreamingChatChoiceUpdate"/>. </summary>
        /// <param name="index"> The ordered index associated with this chat completions choice. </param>
        /// <param name="finishReason"> The reason that this chat completions choice completed its generated. </param>
        /// <param name="delta"> An update to the chat message for a given chat completions prompt. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="delta"/> is null. </exception>
        internal StreamingChatChoiceUpdate(int index, CompletionsFinishReason? finishReason, StreamingChatResponseMessageUpdate delta)
        {
            Argument.AssertNotNull(delta, nameof(delta));

            Index = index;
            FinishReason = finishReason;
            Delta = delta;
        }

        /// <summary> Initializes a new instance of <see cref="StreamingChatChoiceUpdate"/>. </summary>
        /// <param name="index"> The ordered index associated with this chat completions choice. </param>
        /// <param name="finishReason"> The reason that this chat completions choice completed its generated. </param>
        /// <param name="delta"> An update to the chat message for a given chat completions prompt. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal StreamingChatChoiceUpdate(int index, CompletionsFinishReason? finishReason, StreamingChatResponseMessageUpdate delta, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            Index = index;
            FinishReason = finishReason;
            Delta = delta;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Initializes a new instance of <see cref="StreamingChatChoiceUpdate"/> for deserialization. </summary>
        internal StreamingChatChoiceUpdate()
        {
        }

        /// <summary> The ordered index associated with this chat completions choice. </summary>
        public int Index { get; }
        /// <summary> The reason that this chat completions choice completed its generated. </summary>
        public CompletionsFinishReason? FinishReason { get; }
    }
}
