// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.AI.Inference
{
    /// <summary> The type of AI model. </summary>
    public readonly partial struct ModelType : IEquatable<ModelType>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="ModelType"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public ModelType(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string EmbeddingsValue = "embeddings";
        private const string ImageGenerationValue = "image_generation";
        private const string TextGenerationValue = "text_generation";
        private const string ImageEmbeddingsValue = "image_embeddings";
        private const string AudioGenerationValue = "audio_generation";
        private const string ChatValue = "chat";

        /// <summary> Embeddings. </summary>
        public static ModelType Embeddings { get; } = new ModelType(EmbeddingsValue);
        /// <summary> Image generation. </summary>
        public static ModelType ImageGeneration { get; } = new ModelType(ImageGenerationValue);
        /// <summary> Text generation. </summary>
        public static ModelType TextGeneration { get; } = new ModelType(TextGenerationValue);
        /// <summary> Image embeddings. </summary>
        public static ModelType ImageEmbeddings { get; } = new ModelType(ImageEmbeddingsValue);
        /// <summary> Audio generation. </summary>
        public static ModelType AudioGeneration { get; } = new ModelType(AudioGenerationValue);
        /// <summary> Chat completions. </summary>
        public static ModelType Chat { get; } = new ModelType(ChatValue);
        /// <summary> Determines if two <see cref="ModelType"/> values are the same. </summary>
        public static bool operator ==(ModelType left, ModelType right) => left.Equals(right);
        /// <summary> Determines if two <see cref="ModelType"/> values are not the same. </summary>
        public static bool operator !=(ModelType left, ModelType right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="ModelType"/>. </summary>
        public static implicit operator ModelType(string value) => new ModelType(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is ModelType other && Equals(other);
        /// <inheritdoc />
        public bool Equals(ModelType other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
