// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.AI.Inference
{
    /// <summary> Represents some basic information about the AI model. </summary>
    public partial class ModelInfo
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="ModelInfo"/>. </summary>
        /// <param name="modelName"> The name of the AI model. For example: `Phi21`. </param>
        /// <param name="modelType"> The type of the AI model. A Unique identifier for the profile. </param>
        /// <param name="modelProviderName"> The model provider name. For example: `Microsoft Research`. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="modelName"/> or <paramref name="modelProviderName"/> is null. </exception>
        internal ModelInfo(string modelName, ModelType modelType, string modelProviderName)
        {
            Argument.AssertNotNull(modelName, nameof(modelName));
            Argument.AssertNotNull(modelProviderName, nameof(modelProviderName));

            ModelName = modelName;
            ModelType = modelType;
            ModelProviderName = modelProviderName;
        }

        /// <summary> Initializes a new instance of <see cref="ModelInfo"/>. </summary>
        /// <param name="modelName"> The name of the AI model. For example: `Phi21`. </param>
        /// <param name="modelType"> The type of the AI model. A Unique identifier for the profile. </param>
        /// <param name="modelProviderName"> The model provider name. For example: `Microsoft Research`. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal ModelInfo(string modelName, ModelType modelType, string modelProviderName, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            ModelName = modelName;
            ModelType = modelType;
            ModelProviderName = modelProviderName;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Initializes a new instance of <see cref="ModelInfo"/> for deserialization. </summary>
        internal ModelInfo()
        {
        }

        /// <summary> The name of the AI model. For example: `Phi21`. </summary>
        public string ModelName { get; }
        /// <summary> The type of the AI model. A Unique identifier for the profile. </summary>
        public ModelType ModelType { get; }
        /// <summary> The model provider name. For example: `Microsoft Research`. </summary>
        public string ModelProviderName { get; }
    }
}
