// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;
using System.Linq;

namespace Azure.AI.Inference
{
    /// <summary> The configuration information for an embeddings request. </summary>
    public partial class EmbeddingsOptions
    {
        /// <summary> Initializes a new instance of <see cref="EmbeddingsOptions"/>. </summary>
        /// <param name="input">
        /// Input text to embed, encoded as a string or array of tokens.
        /// To embed multiple inputs in a single request, pass an array
        /// of strings or array of token arrays.
        /// </param>
        /// <exception cref="ArgumentNullException"> <paramref name="input"/> is null. </exception>
        public EmbeddingsOptions(IEnumerable<string> input)
        {
            Argument.AssertNotNull(input, nameof(input));

            Input = input.ToList();
            AdditionalProperties = new ChangeTrackingDictionary<string, BinaryData>();
        }

        /// <summary> Initializes a new instance of <see cref="EmbeddingsOptions"/>. </summary>
        /// <param name="input">
        /// Input text to embed, encoded as a string or array of tokens.
        /// To embed multiple inputs in a single request, pass an array
        /// of strings or array of token arrays.
        /// </param>
        /// <param name="dimensions">
        /// Optional. The number of dimensions the resulting output embeddings should have.
        /// Passing null causes the model to use its default value.
        /// Returns a 422 error if the model doesn't support the value or parameter.
        /// </param>
        /// <param name="encodingFormat"> Optional. The desired format for the returned embeddings. </param>
        /// <param name="inputType">
        /// Optional. The type of the input.
        /// Returns a 422 error if the model doesn't support the value or parameter.
        /// </param>
        /// <param name="model"> ID of the specific AI model to use, if more than one model is available on the endpoint. </param>
        /// <param name="additionalProperties"> Additional Properties. </param>
        internal EmbeddingsOptions(IList<string> input, int? dimensions, EmbeddingEncodingFormat? encodingFormat, EmbeddingInputType? inputType, string model, IDictionary<string, BinaryData> additionalProperties)
        {
            Input = input;
            Dimensions = dimensions;
            EncodingFormat = encodingFormat;
            InputType = inputType;
            Model = model;
            AdditionalProperties = additionalProperties;
        }

        /// <summary> Initializes a new instance of <see cref="EmbeddingsOptions"/> for deserialization. </summary>
        internal EmbeddingsOptions()
        {
        }

        /// <summary>
        /// Input text to embed, encoded as a string or array of tokens.
        /// To embed multiple inputs in a single request, pass an array
        /// of strings or array of token arrays.
        /// </summary>
        public IList<string> Input { get; }
        /// <summary>
        /// Optional. The number of dimensions the resulting output embeddings should have.
        /// Passing null causes the model to use its default value.
        /// Returns a 422 error if the model doesn't support the value or parameter.
        /// </summary>
        public int? Dimensions { get; set; }
        /// <summary> Optional. The desired format for the returned embeddings. </summary>
        public EmbeddingEncodingFormat? EncodingFormat { get; set; }
        /// <summary>
        /// Optional. The type of the input.
        /// Returns a 422 error if the model doesn't support the value or parameter.
        /// </summary>
        public EmbeddingInputType? InputType { get; set; }
        /// <summary> ID of the specific AI model to use, if more than one model is available on the endpoint. </summary>
        public string Model { get; set; }
        /// <summary>
        /// Additional Properties
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        public IDictionary<string, BinaryData> AdditionalProperties { get; }
    }
}
