// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.AI.Inference
{
    /// <summary> Representation of a single embeddings relatedness comparison. </summary>
    public partial class EmbeddingItem
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="EmbeddingItem"/>. </summary>
        /// <param name="embedding">
        /// List of embedding values for the input prompt. These represent a measurement of the
        /// vector-based relatedness of the provided input. Or a base64 encoded string of the embedding vector.
        /// </param>
        /// <param name="index"> Index of the prompt to which the EmbeddingItem corresponds. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="embedding"/> is null. </exception>
        internal EmbeddingItem(BinaryData embedding, int index)
        {
            Argument.AssertNotNull(embedding, nameof(embedding));

            Embedding = embedding;
            Index = index;
        }

        /// <summary> Initializes a new instance of <see cref="EmbeddingItem"/>. </summary>
        /// <param name="embedding">
        /// List of embedding values for the input prompt. These represent a measurement of the
        /// vector-based relatedness of the provided input. Or a base64 encoded string of the embedding vector.
        /// </param>
        /// <param name="index"> Index of the prompt to which the EmbeddingItem corresponds. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal EmbeddingItem(BinaryData embedding, int index, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            Embedding = embedding;
            Index = index;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Initializes a new instance of <see cref="EmbeddingItem"/> for deserialization. </summary>
        internal EmbeddingItem()
        {
        }

        /// <summary>
        /// List of embedding values for the input prompt. These represent a measurement of the
        /// vector-based relatedness of the provided input. Or a base64 encoded string of the embedding vector.
        /// <para>
        /// To assign an object to this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// <remarks>
        /// Supported types:
        /// <list type="bullet">
        /// <item>
        /// <description><see cref="string"/></description>
        /// </item>
        /// <item>
        /// <description><see cref="IList{T}"/> where <c>T</c> is of type <see cref="float"/></description>
        /// </item>
        /// </list>
        /// </remarks>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        public BinaryData Embedding { get; }
        /// <summary> Index of the prompt to which the EmbeddingItem corresponds. </summary>
        public int Index { get; }
    }
}
