// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.AI.Inference
{
    /// <summary> Represents the input types used for embedding search. </summary>
    public readonly partial struct EmbeddingInputType : IEquatable<EmbeddingInputType>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="EmbeddingInputType"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public EmbeddingInputType(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string TextValue = "text";
        private const string QueryValue = "query";
        private const string DocumentValue = "document";

        /// <summary> Indicates the input is a general text input. </summary>
        public static EmbeddingInputType Text { get; } = new EmbeddingInputType(TextValue);
        /// <summary> Indicates the input represents a search query to find the most relevant documents in your vector database. </summary>
        public static EmbeddingInputType Query { get; } = new EmbeddingInputType(QueryValue);
        /// <summary> Indicates the input represents a document that is stored in a vector database. </summary>
        public static EmbeddingInputType Document { get; } = new EmbeddingInputType(DocumentValue);
        /// <summary> Determines if two <see cref="EmbeddingInputType"/> values are the same. </summary>
        public static bool operator ==(EmbeddingInputType left, EmbeddingInputType right) => left.Equals(right);
        /// <summary> Determines if two <see cref="EmbeddingInputType"/> values are not the same. </summary>
        public static bool operator !=(EmbeddingInputType left, EmbeddingInputType right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="EmbeddingInputType"/>. </summary>
        public static implicit operator EmbeddingInputType(string value) => new EmbeddingInputType(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is EmbeddingInputType other && Equals(other);
        /// <inheritdoc />
        public bool Equals(EmbeddingInputType other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
