// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.AI.Inference
{
    /// <summary>
    /// The format of the embeddings result.
    /// Returns a 422 error if the model doesn't support the value or parameter.
    /// </summary>
    public readonly partial struct EmbeddingEncodingFormat : IEquatable<EmbeddingEncodingFormat>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="EmbeddingEncodingFormat"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public EmbeddingEncodingFormat(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string Base64Value = "base64";
        private const string BinaryValue = "binary";
        private const string SingleValue = "float";
        private const string SByteValue = "int8";
        private const string UbinaryValue = "ubinary";
        private const string ByteValue = "uint8";

        /// <summary> Base64. </summary>
        public static EmbeddingEncodingFormat Base64 { get; } = new EmbeddingEncodingFormat(Base64Value);
        /// <summary> Binary. </summary>
        public static EmbeddingEncodingFormat Binary { get; } = new EmbeddingEncodingFormat(BinaryValue);
        /// <summary> ubinary. </summary>
        public static EmbeddingEncodingFormat Ubinary { get; } = new EmbeddingEncodingFormat(UbinaryValue);
        /// <summary> Determines if two <see cref="EmbeddingEncodingFormat"/> values are the same. </summary>
        public static bool operator ==(EmbeddingEncodingFormat left, EmbeddingEncodingFormat right) => left.Equals(right);
        /// <summary> Determines if two <see cref="EmbeddingEncodingFormat"/> values are not the same. </summary>
        public static bool operator !=(EmbeddingEncodingFormat left, EmbeddingEncodingFormat right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="EmbeddingEncodingFormat"/>. </summary>
        public static implicit operator EmbeddingEncodingFormat(string value) => new EmbeddingEncodingFormat(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is EmbeddingEncodingFormat other && Equals(other);
        /// <inheritdoc />
        public bool Equals(EmbeddingEncodingFormat other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
