// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.AI.Inference
{
    /// <summary> The EmbedRequest. </summary>
    internal partial class EmbedRequest
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="EmbedRequest"/>. </summary>
        /// <param name="embeddingsOptions"></param>
        /// <exception cref="ArgumentNullException"> <paramref name="embeddingsOptions"/> is null. </exception>
        internal EmbedRequest(EmbeddingsOptions embeddingsOptions)
        {
            Argument.AssertNotNull(embeddingsOptions, nameof(embeddingsOptions));

            EmbeddingsOptions = embeddingsOptions;
        }

        /// <summary> Initializes a new instance of <see cref="EmbedRequest"/>. </summary>
        /// <param name="embeddingsOptions"></param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal EmbedRequest(EmbeddingsOptions embeddingsOptions, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            EmbeddingsOptions = embeddingsOptions;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Initializes a new instance of <see cref="EmbedRequest"/> for deserialization. </summary>
        internal EmbedRequest()
        {
        }

        /// <summary> Gets the embeddings options. </summary>
        public EmbeddingsOptions EmbeddingsOptions { get; }
    }
}
