// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.AI.Inference
{
    /// <summary>
    /// Representation of the token counts processed for a completions request.
    /// Counts consider all tokens across prompts, choices, choice alternates, best_of generations, and
    /// other consumers.
    /// </summary>
    public partial class CompletionsUsage
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="CompletionsUsage"/>. </summary>
        /// <param name="completionTokens"> The number of tokens generated across all completions emissions. </param>
        /// <param name="promptTokens"> The number of tokens in the provided prompts for the completions request. </param>
        /// <param name="totalTokens"> The total number of tokens processed for the completions request and response. </param>
        internal CompletionsUsage(int completionTokens, int promptTokens, int totalTokens)
        {
            CompletionTokens = completionTokens;
            PromptTokens = promptTokens;
            TotalTokens = totalTokens;
        }

        /// <summary> Initializes a new instance of <see cref="CompletionsUsage"/>. </summary>
        /// <param name="completionTokens"> The number of tokens generated across all completions emissions. </param>
        /// <param name="promptTokens"> The number of tokens in the provided prompts for the completions request. </param>
        /// <param name="totalTokens"> The total number of tokens processed for the completions request and response. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal CompletionsUsage(int completionTokens, int promptTokens, int totalTokens, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            CompletionTokens = completionTokens;
            PromptTokens = promptTokens;
            TotalTokens = totalTokens;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Initializes a new instance of <see cref="CompletionsUsage"/> for deserialization. </summary>
        internal CompletionsUsage()
        {
        }

        /// <summary> The number of tokens generated across all completions emissions. </summary>
        public int CompletionTokens { get; }
        /// <summary> The number of tokens in the provided prompts for the completions request. </summary>
        public int PromptTokens { get; }
        /// <summary> The total number of tokens processed for the completions request and response. </summary>
        public int TotalTokens { get; }
    }
}
