// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.AI.Inference
{
    /// <summary> A representation of a chat message as received in a response. </summary>
    public partial class ChatResponseMessage
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="ChatResponseMessage"/>. </summary>
        /// <param name="role"> The chat role associated with the message. </param>
        /// <param name="content"> The content of the message. </param>
        internal ChatResponseMessage(ChatRole role, string content)
        {
            Role = role;
            Content = content;
            ToolCalls = new ChangeTrackingList<ChatCompletionsToolCall>();
        }

        /// <summary> Initializes a new instance of <see cref="ChatResponseMessage"/>. </summary>
        /// <param name="role"> The chat role associated with the message. </param>
        /// <param name="content"> The content of the message. </param>
        /// <param name="toolCalls">
        /// The tool calls that must be resolved and have their outputs appended to subsequent input messages for the chat
        /// completions request to resolve as configured.
        /// </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal ChatResponseMessage(ChatRole role, string content, IReadOnlyList<ChatCompletionsToolCall> toolCalls, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            Role = role;
            Content = content;
            ToolCalls = toolCalls;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Initializes a new instance of <see cref="ChatResponseMessage"/> for deserialization. </summary>
        internal ChatResponseMessage()
        {
        }

        /// <summary> The chat role associated with the message. </summary>
        public ChatRole Role { get; }
        /// <summary> The content of the message. </summary>
        public string Content { get; }
        /// <summary>
        /// The tool calls that must be resolved and have their outputs appended to subsequent input messages for the chat
        /// completions request to resolve as configured.
        /// </summary>
        public IReadOnlyList<ChatCompletionsToolCall> ToolCalls { get; }
    }
}
