// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.AI.Inference
{
    /// <summary> A request chat message representing user input to the assistant. </summary>
    public partial class ChatRequestUserMessage : ChatRequestMessage
    {
        /// <summary> Initializes a new instance of <see cref="ChatRequestUserMessage"/>. </summary>
        /// <param name="role"> The chat role associated with this message. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        /// <param name="content"> The contents of the user message, with available input types varying by selected model. </param>
        internal ChatRequestUserMessage(ChatRole role, IDictionary<string, BinaryData> serializedAdditionalRawData, string content) : base(role, serializedAdditionalRawData)
        {
            Content = content;
        }

        /// <summary> Initializes a new instance of <see cref="ChatRequestUserMessage"/> for deserialization. </summary>
        internal ChatRequestUserMessage()
        {
        }
    }
}
