// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.AI.Inference
{
    /// <summary> A request chat message representing requested output from a configured tool. </summary>
    public partial class ChatRequestToolMessage : ChatRequestMessage
    {
        /// <summary> Initializes a new instance of <see cref="ChatRequestToolMessage"/>. </summary>
        /// <param name="content"> The content of the message. </param>
        /// <param name="toolCallId"> The ID of the tool call resolved by the provided content. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="toolCallId"/> is null. </exception>
        public ChatRequestToolMessage(string content, string toolCallId)
        {
            Argument.AssertNotNull(toolCallId, nameof(toolCallId));

            Role = ChatRole.Tool;
            Content = content;
            ToolCallId = toolCallId;
        }

        /// <summary> Initializes a new instance of <see cref="ChatRequestToolMessage"/>. </summary>
        /// <param name="role"> The chat role associated with this message. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        /// <param name="content"> The content of the message. </param>
        /// <param name="toolCallId"> The ID of the tool call resolved by the provided content. </param>
        internal ChatRequestToolMessage(ChatRole role, IDictionary<string, BinaryData> serializedAdditionalRawData, string content, string toolCallId) : base(role, serializedAdditionalRawData)
        {
            Content = content;
            ToolCallId = toolCallId;
        }

        /// <summary> Initializes a new instance of <see cref="ChatRequestToolMessage"/> for deserialization. </summary>
        internal ChatRequestToolMessage()
        {
        }

        /// <summary> The content of the message. </summary>
        public string Content { get; }
        /// <summary> The ID of the tool call resolved by the provided content. </summary>
        public string ToolCallId { get; }
    }
}
