// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.AI.Inference
{
    /// <summary>
    /// A request chat message containing system instructions that influence how the model will generate a chat completions
    /// response.
    /// </summary>
    public partial class ChatRequestSystemMessage : ChatRequestMessage
    {
        /// <summary> Initializes a new instance of <see cref="ChatRequestSystemMessage"/>. </summary>
        /// <param name="content"> The contents of the system message. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="content"/> is null. </exception>
        public ChatRequestSystemMessage(string content)
        {
            Argument.AssertNotNull(content, nameof(content));

            Role = ChatRole.System;
            Content = content;
        }

        /// <summary> Initializes a new instance of <see cref="ChatRequestSystemMessage"/>. </summary>
        /// <param name="role"> The chat role associated with this message. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        /// <param name="content"> The contents of the system message. </param>
        internal ChatRequestSystemMessage(ChatRole role, IDictionary<string, BinaryData> serializedAdditionalRawData, string content) : base(role, serializedAdditionalRawData)
        {
            Content = content;
        }

        /// <summary> Initializes a new instance of <see cref="ChatRequestSystemMessage"/> for deserialization. </summary>
        internal ChatRequestSystemMessage()
        {
        }

        /// <summary> The contents of the system message. </summary>
        public string Content { get; }
    }
}
