// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.AI.Inference
{
    /// <summary> A structured chat content item containing plain text. </summary>
    public partial class ChatMessageTextContentItem : ChatMessageContentItem
    {
        /// <summary> Initializes a new instance of <see cref="ChatMessageTextContentItem"/>. </summary>
        /// <param name="text"> The content of the message. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="text"/> is null. </exception>
        public ChatMessageTextContentItem(string text)
        {
            Argument.AssertNotNull(text, nameof(text));

            Type = "text";
            Text = text;
        }

        /// <summary> Initializes a new instance of <see cref="ChatMessageTextContentItem"/>. </summary>
        /// <param name="type"> The discriminated object type. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        /// <param name="text"> The content of the message. </param>
        internal ChatMessageTextContentItem(string type, IDictionary<string, BinaryData> serializedAdditionalRawData, string text) : base(type, serializedAdditionalRawData)
        {
            Text = text;
        }

        /// <summary> Initializes a new instance of <see cref="ChatMessageTextContentItem"/> for deserialization. </summary>
        internal ChatMessageTextContentItem()
        {
        }

        /// <summary> The content of the message. </summary>
        public string Text { get; }
    }
}
