// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.AI.Inference
{
    /// <summary> An internet location from which the model may retrieve an image. </summary>
    internal partial class ChatMessageImageUrl
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="ChatMessageImageUrl"/>. </summary>
        /// <param name="url"> The URL of the image. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="url"/> is null. </exception>
        public ChatMessageImageUrl(string url)
        {
            Argument.AssertNotNull(url, nameof(url));

            Url = url;
        }

        /// <summary> Initializes a new instance of <see cref="ChatMessageImageUrl"/>. </summary>
        /// <param name="url"> The URL of the image. </param>
        /// <param name="detail">
        /// The evaluation quality setting to use, which controls relative prioritization of speed, token consumption, and
        /// accuracy.
        /// </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal ChatMessageImageUrl(string url, ChatMessageImageDetailLevel? detail, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            Url = url;
            Detail = detail;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Initializes a new instance of <see cref="ChatMessageImageUrl"/> for deserialization. </summary>
        internal ChatMessageImageUrl()
        {
        }
        /// <summary>
        /// The evaluation quality setting to use, which controls relative prioritization of speed, token consumption, and
        /// accuracy.
        /// </summary>
        public ChatMessageImageDetailLevel? Detail { get; set; }
    }
}
