// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.AI.Inference
{
    /// <summary> Represents a generic policy for how a chat completions tool may be selected. </summary>
    public readonly partial struct ChatCompletionsToolChoicePreset : IEquatable<ChatCompletionsToolChoicePreset>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="ChatCompletionsToolChoicePreset"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public ChatCompletionsToolChoicePreset(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string AutoValue = "auto";
        private const string NoneValue = "none";
        private const string RequiredValue = "required";

        /// <summary>
        /// Specifies that the model may either use any of the tools provided in this chat completions request or
        /// instead return a standard chat completions response as if no tools were provided.
        /// </summary>
        public static ChatCompletionsToolChoicePreset Auto { get; } = new ChatCompletionsToolChoicePreset(AutoValue);
        /// <summary>
        /// Specifies that the model should not respond with a tool call and should instead provide a standard chat
        /// completions response. Response content may still be influenced by the provided tool definitions.
        /// </summary>
        public static ChatCompletionsToolChoicePreset None { get; } = new ChatCompletionsToolChoicePreset(NoneValue);
        /// <summary> Specifies that the model should respond with a call to one or more tools. </summary>
        public static ChatCompletionsToolChoicePreset Required { get; } = new ChatCompletionsToolChoicePreset(RequiredValue);
        /// <summary> Determines if two <see cref="ChatCompletionsToolChoicePreset"/> values are the same. </summary>
        public static bool operator ==(ChatCompletionsToolChoicePreset left, ChatCompletionsToolChoicePreset right) => left.Equals(right);
        /// <summary> Determines if two <see cref="ChatCompletionsToolChoicePreset"/> values are not the same. </summary>
        public static bool operator !=(ChatCompletionsToolChoicePreset left, ChatCompletionsToolChoicePreset right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="ChatCompletionsToolChoicePreset"/>. </summary>
        public static implicit operator ChatCompletionsToolChoicePreset(string value) => new ChatCompletionsToolChoicePreset(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is ChatCompletionsToolChoicePreset other && Equals(other);
        /// <inheritdoc />
        public bool Equals(ChatCompletionsToolChoicePreset other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
