// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.AI.Inference
{
    /// <summary> The ChatCompletionsToolCall_type. </summary>
    public readonly partial struct ChatCompletionsToolCallType : IEquatable<ChatCompletionsToolCallType>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="ChatCompletionsToolCallType"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public ChatCompletionsToolCallType(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string FunctionValue = "function";

        /// <summary> function. </summary>
        public static ChatCompletionsToolCallType Function { get; } = new ChatCompletionsToolCallType(FunctionValue);
        /// <summary> Determines if two <see cref="ChatCompletionsToolCallType"/> values are the same. </summary>
        public static bool operator ==(ChatCompletionsToolCallType left, ChatCompletionsToolCallType right) => left.Equals(right);
        /// <summary> Determines if two <see cref="ChatCompletionsToolCallType"/> values are not the same. </summary>
        public static bool operator !=(ChatCompletionsToolCallType left, ChatCompletionsToolCallType right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="ChatCompletionsToolCallType"/>. </summary>
        public static implicit operator ChatCompletionsToolCallType(string value) => new ChatCompletionsToolCallType(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is ChatCompletionsToolCallType other && Equals(other);
        /// <inheritdoc />
        public bool Equals(ChatCompletionsToolCallType other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
