// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.AI.Inference
{
    /// <summary>
    /// A response format for Chat Completions that restricts responses to emitting valid JSON objects.
    /// Note that to enable JSON mode, some AI models may also require you to instruct the model to produce JSON
    /// via a system or user message.
    /// </summary>
    public partial class ChatCompletionsResponseFormatJSON : ChatCompletionsResponseFormat
    {
        /// <summary> Initializes a new instance of <see cref="ChatCompletionsResponseFormatJSON"/>. </summary>
        public ChatCompletionsResponseFormatJSON()
        {
            Type = "json_object";
        }

        /// <summary> Initializes a new instance of <see cref="ChatCompletionsResponseFormatJSON"/>. </summary>
        /// <param name="type"> The response format type to use for chat completions. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal ChatCompletionsResponseFormatJSON(string type, IDictionary<string, BinaryData> serializedAdditionalRawData) : base(type, serializedAdditionalRawData)
        {
        }
    }
}
